/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social.networking.ws.methods.v2;

import com.webcohesion.enunciate.metadata.rs.RequestHeader;
import com.webcohesion.enunciate.metadata.rs.RequestHeaders;
import com.webcohesion.enunciate.metadata.rs.ResponseCode;
import com.webcohesion.enunciate.metadata.rs.StatusCodes;
import java.util.List;
import javax.validation.ValidationException;
import javax.validation.constraints.Min;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.utils.Caller;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portal.social.networking.ws.outputs.ResponseBean;
import org.gcube.portal.social.networking.ws.utils.CassandraConnection;
import org.gcube.portal.social.networking.ws.utils.Filters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="2/comments")
@RequestHeaders(value={@RequestHeader(name="Authorization", description="Bearer token, see https://dev.d4science.org/how-to-access-resources"), @RequestHeader(name="Content-Type", description="application/json")})
public class Comments {
    private static final Logger logger = LoggerFactory.getLogger(Comments.class);

    @GET
    @Produces(value={"application/json"})
    @Path(value="get-comments-user")
    @StatusCodes(value={@ResponseCode(code=200, condition="The list of comments is put into the 'result' field"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    public Response getCommentsUser() {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        Caller caller = AuthorizationProvider.instance.get();
        String context = ScopeProvider.instance.get();
        String username = caller.getClient().getId();
        List comments = null;
        try {
            logger.info("Retrieving comments for user id " + username);
            comments = CassandraConnection.getInstance().getDatabookStore().getRecentCommentsByUserAndDate(username, 0L);
            Filters.filterCommentsPerContext((List)comments, (String)context);
            responseBean.setResult((Object)comments);
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve such comments.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="get-comments-user-by-time")
    public Response getCommentsUserByTime(@QueryParam(value="time") @Min(value=0L, message="time cannot be negative") long timeInMillis) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        Caller caller = AuthorizationProvider.instance.get();
        String context = ScopeProvider.instance.get();
        String username = caller.getClient().getId();
        List comments = null;
        try {
            logger.info("Retrieving comments for user id " + username);
            comments = CassandraConnection.getInstance().getDatabookStore().getRecentCommentsByUserAndDate(username, timeInMillis);
            Filters.filterCommentsPerContext((List)comments, (String)context);
            responseBean.setResult((Object)comments);
            responseBean.setMessage("");
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve such comments.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }
}

