/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social.networking.ws.inputs;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.webcohesion.enunciate.metadata.DocumentationExample;
import javax.validation.constraints.NotNull;
import org.gcube.portal.databook.shared.JobStatusType;
import org.gcube.portal.databook.shared.RunningJob;
import org.gcube.portal.social.networking.ws.providers.JobStatusTypeDeserializer;

@JsonIgnoreProperties(ignoreUnknown=true)
public class JobNotificationBean {
    @JsonProperty(value="recipient")
    @NotNull(message="recipient cannot be missing")
    @DocumentationExample(value="andrea.rossi")
    private String recipient;
    @JsonProperty(value="job_id")
    private String jobId;
    @JsonProperty(value="job_name")
    private String jobName;
    @JsonProperty(value="service_name")
    @NotNull(message="service_name cannot be missing")
    private String serviceName;
    @JsonProperty(value="status")
    @JsonDeserialize(using=JobStatusTypeDeserializer.class)
    @NotNull(message="status cannot be missing")
    private JobStatusType status;
    @JsonProperty(value="status_message")
    private String statusMessage;

    public JobNotificationBean() {
    }

    public JobNotificationBean(String recipient, String jobId, String jobName, String serviceName, JobStatusType status, String statusMessage) {
        this.recipient = recipient;
        this.jobId = jobId;
        this.jobName = jobName;
        this.serviceName = serviceName;
        this.status = status;
        this.statusMessage = statusMessage;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public JobStatusType getStatus() {
        return this.status;
    }

    public void setStatus(JobStatusType status) {
        this.status = status;
    }

    public RunningJob getRunningJob() {
        return new RunningJob(this.jobId, this.jobName, this.status, this.statusMessage, this.serviceName);
    }

    public String toString() {
        return "JobNotificationBean [" + (this.recipient != null ? "recipient=" + this.recipient + ", " : "") + (this.jobId != null ? "jobId=" + this.jobId + ", " : "") + (this.jobName != null ? "jobName=" + this.jobName + ", " : "") + (this.serviceName != null ? "serviceName=" + this.serviceName + ", " : "") + (this.status != null ? "status=" + this.status + ", " : "") + (this.statusMessage != null ? "statusMessage=" + this.statusMessage : "") + "]";
    }
}

