/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social.networking.ws.methods.v2;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.List;
import javax.validation.ValidationException;
import javax.validation.constraints.Min;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.utils.Caller;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portal.social.networking.ws.outputs.ResponseBean;
import org.gcube.portal.social.networking.ws.utils.CassandraConnection;
import org.gcube.portal.social.networking.ws.utils.Filters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="2/comments")
@Api(value="comments", authorizations={@Authorization(value="gcube-token-query"), @Authorization(value="gcube-token-header")})
public class Comments {
    private static final Logger logger = LoggerFactory.getLogger(Comments.class);

    @GET
    @Produces(value={"application/json"})
    @Path(value="get-comments-user")
    @ApiOperation(value="Retrieve user's comments", response=ResponseBean.class, nickname="get-comments-user", notes="Retrieve the list of comments belonging to the owner of the token in the related context.")
    @ApiResponses(value={@ApiResponse(code=200, message="The list of comments is put into the 'result' field", response=ResponseBean.class), @ApiResponse(code=500, message="The error is reported into the 'message' field of the returned object", response=ResponseBean.class)})
    public Response getCommentsUser() {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        Caller caller = AuthorizationProvider.instance.get();
        String context = ScopeProvider.instance.get();
        String username = caller.getClient().getId();
        List comments = null;
        try {
            logger.info("Retrieving comments for user id " + username);
            comments = CassandraConnection.getInstance().getDatabookStore().getRecentCommentsByUserAndDate(username, 0L);
            Filters.filterCommentsPerContext((List)comments, (String)context);
            responseBean.setResult((Object)comments);
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve such comments.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="get-comments-user-by-time")
    @ApiOperation(value="Retrieve user's comments and filter by date", notes="Retrieve comments of the gcube-token's owner in the context bound to the token itself and filter them by date", response=ResponseBean.class, nickname="get-comments-user-by-time")
    @ApiResponses(value={@ApiResponse(code=200, message="The list of comments is put into the 'result' field", response=ResponseBean.class), @ApiResponse(code=500, message="The error is reported into the 'message' field of the returned object", response=ResponseBean.class)})
    public Response getCommentsUserByTime(@QueryParam(value="time") @Min(value=0L, message="time cannot be negative") @ApiParam(allowableValues="range[0, infinity]", required=true, name="time", value="the base time for filtering operation") long timeInMillis) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        Caller caller = AuthorizationProvider.instance.get();
        String context = ScopeProvider.instance.get();
        String username = caller.getClient().getId();
        List comments = null;
        try {
            logger.info("Retrieving comments for user id " + username);
            comments = CassandraConnection.getInstance().getDatabookStore().getRecentCommentsByUserAndDate(username, timeInMillis);
            Filters.filterCommentsPerContext((List)comments, (String)context);
            responseBean.setResult((Object)comments);
            responseBean.setMessage("");
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve such comments.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }
}

