/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social.networking.ws.methods.v1;

import java.util.ArrayList;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.gcube.applicationsupportlayer.social.ApplicationNotificationsManager;
import org.gcube.applicationsupportlayer.social.NotificationsManager;
import org.gcube.applicationsupportlayer.social.shared.SocialNetworkingSite;
import org.gcube.applicationsupportlayer.social.shared.SocialNetworkingUser;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.utils.Caller;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portal.notifications.bean.GenericItemBean;
import org.gcube.portal.notifications.thread.MessageNotificationsThread;
import org.gcube.portal.social.networking.caches.SocialNetworkingSiteFinder;
import org.gcube.portal.social.networking.liferay.ws.UserManagerWSBuilder;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/messages")
@Deprecated
public class Messages {
    private static final Logger logger = LoggerFactory.getLogger(Messages.class);
    private static final String RECIPIENTS_ID_SEPARATOR = ",";
    private UserManager uManager = UserManagerWSBuilder.getInstance().getUserManager();

    @POST
    @Path(value="writeMessageToUsers/")
    @Produces(value={"application/json", "text/plain"})
    public Response writeMessageToUsers(@FormParam(value="sender") String sender, @FormParam(value="body") String body, @FormParam(value="subject") String subject, @FormParam(value="recipients") String recipientsIds) {
        if (body == null || body.isEmpty() || subject == null || subject.isEmpty() || recipientsIds == null || recipientsIds.isEmpty()) {
            logger.error("Missing/wrong request parameters");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Missing request parameters.").build();
        }
        Caller caller = AuthorizationProvider.instance.get();
        String senderId = caller.getClient().getId();
        String scope = ScopeProvider.instance.get();
        if (sender == null || sender.isEmpty()) {
            logger.info("Sender is going to be the token's owner [" + senderId + "]");
        } else {
            logger.info("Sender is going to be " + sender);
            senderId = sender;
        }
        ArrayList<String> recipientsListFiltered = new ArrayList<String>();
        String[] splittedRecipientsIds = recipientsIds.split(RECIPIENTS_ID_SEPARATOR);
        ArrayList<GenericItemBean> recipientsBeans = new ArrayList<GenericItemBean>();
        for (String recipientId : splittedRecipientsIds) {
            try {
                String tempId = recipientId.trim();
                if (tempId.isEmpty()) continue;
                GCubeUser userRecipient = this.uManager.getUserByUsername(tempId);
                GenericItemBean beanUser = new GenericItemBean(userRecipient.getUsername(), userRecipient.getUsername(), userRecipient.getFullname(), userRecipient.getUserAvatarURL());
                recipientsBeans.add(beanUser);
                recipientsListFiltered.add(tempId);
            }
            catch (Exception e) {
                logger.error("Unable to retrieve recipient information for recipient with id " + recipientId, (Throwable)e);
            }
        }
        if (recipientsListFiltered.isEmpty()) {
            logger.error("Missing/wrong request parameters");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Please check the parameter you passed, it seems a bad request").build();
        }
        try {
            logger.info("Trying to send message with body " + body + " subject " + subject + " to user " + recipientsIds + " from " + senderId);
            GCubeUser senderUser = this.uManager.getUserByUsername(senderId);
            Workspace workspace = HomeLibrary.getUserWorkspace((String)senderId);
            logger.debug("Sending message to " + recipientsListFiltered);
            String messageId = workspace.getWorkspaceMessageManager().sendMessageToPortalLogins(subject, body, new ArrayList(), recipientsListFiltered);
            logger.debug("Message sent to " + recipientsIds + ". Sending message notification to: " + recipientsIds);
            SocialNetworkingSite site = SocialNetworkingSiteFinder.getSocialNetworkingSiteFromScope((String)scope);
            SocialNetworkingUser user = new SocialNetworkingUser(senderUser.getUsername(), senderUser.getEmail(), senderUser.getFullname(), senderUser.getUserAvatarURL());
            logger.info("SocialNetworkingUser is " + user);
            ApplicationNotificationsManager nm = new ApplicationNotificationsManager(UserManagerWSBuilder.getInstance().getUserManager(), site, scope, user);
            new Thread((Runnable)new MessageNotificationsThread(recipientsBeans, messageId, subject, body, (NotificationsManager)nm)).start();
        }
        catch (Exception e) {
            logger.error("Unable to send message.", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }
}

