/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social.networking.ws.methods.v2;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ValidationException;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.utils.Caller;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portal.databook.shared.EnhancedFeed;
import org.gcube.portal.databook.shared.Feed;
import org.gcube.portal.social.networking.liferay.ws.GroupManagerWSBuilder;
import org.gcube.portal.social.networking.liferay.ws.UserManagerWSBuilder;
import org.gcube.portal.social.networking.ws.outputs.ResponseBean;
import org.gcube.portal.social.networking.ws.utils.CassandraConnection;
import org.gcube.portal.social.networking.ws.utils.ElasticSearchConnection;
import org.gcube.portal.social.networking.ws.utils.Filters;
import org.gcube.portal.social.networking.ws.utils.TokensUtils;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeGroup;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="2/full-text-search")
@Api(value="full-text-search", authorizations={@Authorization(value="gcube-token-query"), @Authorization(value="gcube-token-header")})
public class FullTextSearch {
    private static final Logger logger = LoggerFactory.getLogger(FullTextSearch.class);

    @GET
    @Path(value="search-by-query")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve posts/comments that match the given query", notes="The posts/comments returned belong to the context bound to the gcube-token", response=ResponseBean.class, nickname="search-by-query")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful retrieval of posts/comments that match the query, reported in the 'result' field of the returned object", response=ResponseBean.class), @ApiResponse(code=500, message="The error is reported into the 'message' field of the returned object", response=ResponseBean.class)})
    public Response searchByQuery(@Context HttpServletRequest httpServletRequest, @QueryParam(value="query") @NotNull(message="query cannot be null") @Size(min=1, message="query cannot be empty") @ApiParam(required=true, defaultValue="none", name="query", value="A string to search for") String query, @DefaultValue(value="0") @QueryParam(value="from") @Min(value=0L, message="from cannot be negative") @ApiParam(allowableValues="range[0, infinity]", required=false, name="from", value="the index of the base result to be returned") int from, @DefaultValue(value="10") @QueryParam(value="quantity") @Min(value=0L, message="quantity cannot be negative") @ApiParam(allowableValues="range[1, infinity]", required=false, name="quantity", value="defines how many results are most are to be returned") int quantity) throws ValidationException {
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        String context = ScopeProvider.instance.get();
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.BAD_REQUEST;
        responseBean.setMessage("This method can be only invoked by using a user token.");
        if (!TokensUtils.isUserToken((Caller)caller)) {
            return Response.status((Response.Status)status).entity((Object)responseBean).build();
        }
        status = Response.Status.OK;
        responseBean.setMessage(null);
        GroupManager groupManager = GroupManagerWSBuilder.getInstance().getGroupManager();
        UserManager userManager = UserManagerWSBuilder.getInstance().getUserManager();
        try {
            HashSet<String> vres = new HashSet<String>();
            long currentGroupId = groupManager.getGroupIdFromInfrastructureScope(context);
            GCubeUser currUser = userManager.getUserByUsername(username);
            List userContexts = groupManager.listGroupsByUser(currUser.getUserId());
            if (groupManager.isRootVO(currentGroupId).booleanValue()) {
                for (GCubeGroup group : groupManager.listGroupsByUser(currUser.getUserId())) {
                    if (!groupManager.isVRE(group.getGroupId()).booleanValue() || !userContexts.contains(group)) continue;
                    vres.add(groupManager.getInfrastructureScope(group.getGroupId()));
                }
            } else if (groupManager.isVO(currentGroupId).booleanValue()) {
                for (GCubeGroup group : groupManager.listGroupsByUser(currUser.getUserId())) {
                    if (!groupManager.isVRE(group.getGroupId()).booleanValue() || group.getParentGroupId() != currentGroupId || !userContexts.contains(group)) continue;
                    vres.add(groupManager.getInfrastructureScope(group.getGroupId()));
                }
            } else {
                vres.add(context);
            }
            List enhancedFeeds = ElasticSearchConnection.getSingleton().getElasticSearchClient().search(query, vres, from, quantity);
            Filters.hideSensitiveInformation((List)enhancedFeeds, (String)caller.getClient().getId());
            DatabookStore store = CassandraConnection.getInstance().getDatabookStore();
            List likedFeeds = store.getAllLikedFeedIdsByUser(username);
            for (EnhancedFeed enhancedFeed : enhancedFeeds) {
                if (FullTextSearch.isUsers((Feed)enhancedFeed.getFeed(), (String)username)) {
                    enhancedFeed.setUsers(true);
                }
                if (!likedFeeds.contains(enhancedFeed.getFeed().getKey())) continue;
                enhancedFeed.setLiked(true);
            }
            responseBean.setResult((Object)((ArrayList)enhancedFeeds));
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Something went wrong while searching", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    private static final boolean isUsers(Feed tocheck, String username) {
        return tocheck.getEntityId().equals(username);
    }
}

