/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social.networking.ws.methods.v2;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.validation.ValidationException;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.utils.Caller;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.portal.social.networking.caches.UsersCache;
import org.gcube.portal.social.networking.liferay.ws.GroupManagerWSBuilder;
import org.gcube.portal.social.networking.liferay.ws.RoleManagerWSBuilder;
import org.gcube.portal.social.networking.liferay.ws.UserManagerWSBuilder;
import org.gcube.portal.social.networking.ws.outputs.ResponseBean;
import org.gcube.portal.social.networking.ws.utils.TokensUtils;
import org.gcube.portal.social.networking.ws.utils.UserProfileExtendedWithVerifiedEmail;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.RoleManager;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeRole;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="2/users")
@Api(value="users", authorizations={@Authorization(value="gcube-token-query"), @Authorization(value="gcube-token-header")})
public class Users {
    private static final Logger logger = LoggerFactory.getLogger(Users.class);
    private static final String NOT_USER_TOKEN_CONTEXT_USED = "User's information can only be retrieved through a user token (not qualified)";
    private static final List<String> GLOBAL_ROLES_ALLOWED_BY_LOCAL_CALL_METHOD = Arrays.asList("DataMiner-Manager", "Quota-Manager");
    private static final Function<GCubeUser, UserProfileExtendedWithVerifiedEmail> GCUBE_TO_EXTENDED_PROFILE_MAP_WITH_VERIFIED_EMAIL = new /* Unavailable Anonymous Inner Class!! */;

    @GET
    @Path(value="get-custom-attribute/")
    @Produces(value={"application/json"})
    @ApiOperation(value="Read a user's custom attribute", notes="Read a user's custom attribute. The user is the one owning the token", response=ResponseBean.class, nickname="get-custom-attribute")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful read of the attribute, reported in the 'result' field of the returned object", response=ResponseBean.class), @ApiResponse(code=404, message="Such an attribute doesn't exist", response=ResponseBean.class), @ApiResponse(code=500, message="The error is reported into the 'message' field of the returned object", response=ResponseBean.class)})
    public Response readCustomAttr(@QueryParam(value="attribute") @NotNull(message="attribute name is missing") @ApiParam(name="attribute", required=true, allowMultiple=false, value="The key of the attribute to be read") String attributeKey) throws ValidationException {
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        if (!TokensUtils.isUserTokenDefault((Caller)caller)) {
            status = Response.Status.FORBIDDEN;
            responseBean.setMessage(NOT_USER_TOKEN_CONTEXT_USED);
            logger.warn("Trying to access users method via a token different than USER is not allowed");
        } else {
            UserManager userManager = UserManagerWSBuilder.getInstance().getUserManager();
            try {
                GCubeUser user = userManager.getUserByUsername(username);
                String toReturn = (String)((Object)userManager.readCustomAttr(user.getUserId(), attributeKey));
                responseBean.setSuccess(true);
                responseBean.setResult((Object)toReturn);
            }
            catch (Exception e) {
                logger.error("Unable to retrieve attribute for user.", (Throwable)e);
                responseBean.setMessage(e.toString());
                responseBean.setSuccess(false);
                status = Response.Status.NOT_FOUND;
            }
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Path(value="get-fullname")
    @Produces(value={"application/json"})
    @ApiOperation(value="Read the user's fullname", notes="Read the user's fullname. The user is the one owning the token", response=ResponseBean.class, nickname="get-fullname")
    @ApiResponses(value={@ApiResponse(code=200, message="The user's fullname is reported in the 'result' field of the returned object", response=ResponseBean.class), @ApiResponse(code=500, message="The error is reported into the 'message' field of the returned object", response=ResponseBean.class)})
    public Response getUserFullname() {
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        String fullName = null;
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        if (!TokensUtils.isUserTokenDefault((Caller)caller)) {
            status = Response.Status.FORBIDDEN;
            responseBean.setMessage(NOT_USER_TOKEN_CONTEXT_USED);
            logger.warn("Trying to access users method via a token different than USER is not allowed");
        } else {
            UserManager userManager = UserManagerWSBuilder.getInstance().getUserManager();
            try {
                GCubeUser user = userManager.getUserByUsername(username);
                fullName = user.getFullname();
                logger.info("Found fullname " + fullName + " for user " + username);
                responseBean.setResult((Object)fullName);
                responseBean.setSuccess(true);
            }
            catch (Exception e) {
                logger.error("Unable to retrieve attribute for user.", (Throwable)e);
                status = Response.Status.INTERNAL_SERVER_ERROR;
            }
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Path(value="get-email")
    @Produces(value={"application/json"})
    @ApiOperation(value="Read the user's email address", notes="Read the user's email address. The user is the one owning the token", response=ResponseBean.class, nickname="get-email")
    @ApiResponses(value={@ApiResponse(code=200, message="The user's email value is reported in the 'result' field of the returned object", response=ResponseBean.class), @ApiResponse(code=500, message="The error is reported into the 'message' field of the returned object", response=ResponseBean.class)})
    public Response getUserEmail() {
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        String email = null;
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        if (!TokensUtils.isUserTokenDefault((Caller)caller)) {
            status = Response.Status.FORBIDDEN;
            responseBean.setMessage(NOT_USER_TOKEN_CONTEXT_USED);
            logger.warn("Trying to access users method via a token different than USER is not allowed");
        } else {
            try {
                UserManager userManager = UserManagerWSBuilder.getInstance().getUserManager();
                GCubeUser user = userManager.getUserByUsername(username);
                email = user.getEmail();
                logger.info("Found email " + email + " for user " + username);
                responseBean.setResult((Object)email);
                responseBean.setSuccess(true);
            }
            catch (Exception e) {
                logger.error("Unable to retrieve attribute for user.", (Throwable)e);
                status = Response.Status.INTERNAL_SERVER_ERROR;
            }
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Path(value="get-profile")
    @Produces(value={"application/json"})
    @ApiOperation(value="Read the user's profile", notes="Read the user's profile. The user is the one owning the token", response=ResponseBean.class, nickname="get-profile")
    @ApiResponses(value={@ApiResponse(code=200, message="The user's profile is reported in the 'result' field of the returned object", response=ResponseBean.class), @ApiResponse(code=500, message="The error is reported into the 'message' field of the returned object", response=ResponseBean.class)})
    public Response getUserProfile() {
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        GCubeUser user = null;
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        if (!TokensUtils.isUserTokenDefault((Caller)caller)) {
            status = Response.Status.FORBIDDEN;
            responseBean.setMessage(NOT_USER_TOKEN_CONTEXT_USED);
            logger.warn("Trying to access users method via a token different than USER is not allowed");
        } else {
            try {
                UserManager userManager = UserManagerWSBuilder.getInstance().getUserManager();
                user = userManager.getUserByUsername(username);
                responseBean.setResult((Object)user);
                responseBean.setSuccess(true);
            }
            catch (Exception e) {
                logger.error("Unable to retrieve user's profile", (Throwable)e);
                responseBean.setMessage(e.getMessage());
                status = Response.Status.INTERNAL_SERVER_ERROR;
            }
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Path(value="get-oauth-profile")
    @Produces(value={"application/json"})
    public Response getUserOAuthProfile() {
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        String scope = ScopeProvider.instance.get();
        GCubeUser user = null;
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        UserProfileExtendedWithVerifiedEmail userWithEmailVerified = null;
        if (!TokensUtils.isUserTokenDefault((Caller)caller) && !TokensUtils.isUserTokenQualified((Caller)caller)) {
            status = Response.Status.FORBIDDEN;
            responseBean.setMessage(NOT_USER_TOKEN_CONTEXT_USED);
            logger.warn("Trying to access users method via a token different than USER is not allowed");
        } else {
            try {
                UserManager userManager = UserManagerWSBuilder.getInstance().getUserManager();
                RoleManager roleManager = RoleManagerWSBuilder.getInstance().getRoleManager();
                GroupManager groupManager = GroupManagerWSBuilder.getInstance().getGroupManager();
                user = userManager.getUserByUsername(username);
                userWithEmailVerified = (UserProfileExtendedWithVerifiedEmail)GCUBE_TO_EXTENDED_PROFILE_MAP_WITH_VERIFIED_EMAIL.apply(user);
                List roles = roleManager.listRolesByUserAndGroup(user.getUserId(), groupManager.getGroupIdFromInfrastructureScope(scope));
                ArrayList<String> rolesNames = new ArrayList<String>();
                for (GCubeRole gCubeRole : roles) {
                    rolesNames.add(gCubeRole.getRoleName());
                }
                userWithEmailVerified.setRoles(rolesNames);
                responseBean.setSuccess(true);
            }
            catch (Exception e) {
                logger.error("Unable to retrieve user's profile", (Throwable)e);
                responseBean.setMessage(e.getMessage());
                status = Response.Status.INTERNAL_SERVER_ERROR;
            }
        }
        logger.debug("returning: " + userWithEmailVerified.toString());
        return Response.status((Response.Status)status).entity((Object)userWithEmailVerified).build();
    }

    @GET
    @Path(value="get-all-usernames")
    @ApiOperation(value="Get the list of usernames belonging to a given context", notes="Retrieve the list of usernames for the user belonging to the context linked to the provided token.", response=ResponseBean.class, nickname="get-all-usernames")
    @ApiResponses(value={@ApiResponse(code=200, message="The list of usernames is put into the 'result' field of the returned object", response=ResponseBean.class), @ApiResponse(code=500, message="The error is reported into the 'message' field of the returned object", response=ResponseBean.class)})
    @Produces(value={"application/json"})
    public Response getAllUserNames() {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        ArrayList<String> usernames = new ArrayList<String>();
        try {
            GroupManager groupManager = GroupManagerWSBuilder.getInstance().getGroupManager();
            UserManager userManager = UserManagerWSBuilder.getInstance().getUserManager();
            long groupId = groupManager.getGroupIdFromInfrastructureScope(ScopeProvider.instance.get());
            List userIds = userManager.getUserIdsByGroup(groupId);
            UsersCache cache = UsersCache.getSingleton();
            for (Long userId : userIds) {
                if (cache.getUser(userId.longValue()) == null) {
                    GCubeUser user = userManager.getUserById(userId.longValue());
                    if (user == null) continue;
                    usernames.add(user.getUsername());
                    cache.pushEntry(userId.longValue(), user);
                    continue;
                }
                usernames.add(cache.getUser(userId.longValue()).getUsername());
            }
            responseBean.setResult(usernames);
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve user's usernames", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Path(value="get-all-fullnames-and-usernames")
    @ApiOperation(value="Get the map of couples username/fullname of the users belonging to a given context", notes="Get the map of couples username/fullname of the users belonging to the context linked to the provided token.", response=ResponseBean.class, nickname="get-all-fullnames-and-usernames")
    @ApiResponses(value={@ApiResponse(code=200, message="The map is put into the 'result' field of the returned object", response=ResponseBean.class), @ApiResponse(code=500, message="The error is reported into the 'message' field of the returned object", response=ResponseBean.class)})
    @Produces(value={"application/json"})
    public Response getFullnamesAndUsernames() {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        HashMap<String, String> usernamesAndFullnames = new HashMap<String, String>();
        try {
            GroupManager groupManager = GroupManagerWSBuilder.getInstance().getGroupManager();
            UserManager userManager = UserManagerWSBuilder.getInstance().getUserManager();
            long groupId = groupManager.getGroupIdFromInfrastructureScope(ScopeProvider.instance.get());
            List userIds = userManager.getUserIdsByGroup(groupId);
            UsersCache cache = UsersCache.getSingleton();
            for (Long userId : userIds) {
                if (cache.getUser(userId.longValue()) == null) {
                    GCubeUser user = userManager.getUserById(userId.longValue());
                    if (user == null) continue;
                    usernamesAndFullnames.put(user.getUsername(), user.getFullname());
                    cache.pushEntry(userId.longValue(), user);
                    continue;
                }
                usernamesAndFullnames.put(cache.getUser(userId.longValue()).getUsername(), cache.getUser(userId.longValue()).getFullname());
            }
            responseBean.setResult(usernamesAndFullnames);
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve user's usernames", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Path(value="get-usernames-by-global-role")
    @ApiOperation(value="Get the list of users having a given global-role", notes="Get the list of users having a given global-role, e.g. 'Administrator'.", response=ResponseBean.class, nickname="get-usernames-by-global-role")
    @ApiResponses(value={@ApiResponse(code=200, message="The list is put into the 'result' field of the returned object", response=ResponseBean.class), @ApiResponse(code=500, message="The error is reported into the 'message' field of the returned object", response=ResponseBean.class)})
    @Produces(value={"application/json"})
    public Response getUsernamesByGlobalRole(@ApiParam(value="role-name: the name of the role to be checked (e.g. Administrator)", required=true) @QueryParam(value="role-name") String roleName) {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        ScopeBean scopeInfo = new ScopeBean(ScopeProvider.instance.get());
        if (!scopeInfo.is(ScopeBean.Type.INFRASTRUCTURE)) {
            status = Response.Status.BAD_REQUEST;
            responseBean.setMessage("This method can only be called with an infrastructure token");
        } else {
            ArrayList<String> usernames = new ArrayList<String>();
            try {
                RoleManager roleManager = RoleManagerWSBuilder.getInstance().getRoleManager();
                long globalRoleId = roleManager.getRoleIdByName(roleName);
                if (globalRoleId > 0L) {
                    UserManager userManager = UserManagerWSBuilder.getInstance().getUserManager();
                    List users = userManager.listUsersByGlobalRole(globalRoleId);
                    if (users != null) {
                        for (GCubeUser gCubeUser : users) {
                            usernames.add(gCubeUser.getUsername());
                        }
                    }
                    responseBean.setResult(usernames);
                    responseBean.setSuccess(true);
                } else {
                    responseBean.setMessage("No global role exists whit such a name");
                    status = Response.Status.BAD_REQUEST;
                }
            }
            catch (Exception e) {
                logger.error("Unable to retrieve user's usernames", (Throwable)e);
                responseBean.setMessage(e.getMessage());
                status = Response.Status.INTERNAL_SERVER_ERROR;
            }
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Path(value="get-usernames-by-role")
    @Produces(value={"application/json"})
    public Response getUsernamesByRole(@QueryParam(value="role-name") String roleName) {
        Response.Status status;
        ResponseBean responseBean;
        block9: {
            responseBean = new ResponseBean();
            status = Response.Status.OK;
            String context = ScopeProvider.instance.get();
            ArrayList<String> usernames = new ArrayList<String>();
            try {
                GroupManager groupManager = GroupManagerWSBuilder.getInstance().getGroupManager();
                RoleManager roleManager = RoleManagerWSBuilder.getInstance().getRoleManager();
                long roleId = roleManager.getRoleIdByName(roleName);
                if (roleId > 0L) {
                    UserManager userManager = UserManagerWSBuilder.getInstance().getUserManager();
                    List users = null;
                    long groupId = groupManager.getGroupIdFromInfrastructureScope(context);
                    try {
                        if (GLOBAL_ROLES_ALLOWED_BY_LOCAL_CALL_METHOD.contains(roleName)) {
                            users = userManager.listUsersByGlobalRole(roleId);
                        }
                    }
                    catch (Exception globalExp) {
                        logger.warn("Failed while checking for global role... trying with local one", (Throwable)globalExp);
                    }
                    if (users == null || users.isEmpty()) {
                        logger.debug("User list is still null/empty, checking for local information");
                        users = userManager.listUsersByGroupAndRole(groupId, roleId);
                    }
                    if (users != null) {
                        for (GCubeUser gCubeUser : users) {
                            usernames.add(gCubeUser.getUsername());
                        }
                    }
                    responseBean.setResult(usernames);
                    responseBean.setSuccess(true);
                    break block9;
                }
                responseBean.setMessage("No role exists whit such a name");
                status = Response.Status.BAD_REQUEST;
            }
            catch (Exception e) {
                logger.error("Unable to retrieve user's usernames", (Throwable)e);
                responseBean.setMessage(e.getMessage());
                status = Response.Status.INTERNAL_SERVER_ERROR;
            }
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Path(value="user-exists")
    @Produces(value={"application/json"})
    public Response existUser(@QueryParam(value="username") String username) {
        ResponseBean responseBean = new ResponseBean();
        String messageOnError = "This method can be invoked only by using an application token bound to the root context";
        Response.Status status = Response.Status.BAD_REQUEST;
        responseBean.setMessage(messageOnError);
        responseBean.setSuccess(false);
        Caller caller = AuthorizationProvider.instance.get();
        if (!TokensUtils.isApplicationToken((Caller)caller)) {
            return Response.status((Response.Status)status).entity((Object)responseBean).build();
        }
        ScopeBean scopeInfo = new ScopeBean(ScopeProvider.instance.get());
        if (!scopeInfo.is(ScopeBean.Type.INFRASTRUCTURE)) {
            return Response.status((Response.Status)status).entity((Object)responseBean).build();
        }
        try {
            UserManager userManager = UserManagerWSBuilder.getInstance().getUserManager();
            GCubeUser user = userManager.getUserByUsername(username);
            responseBean.setSuccess(true);
            responseBean.setMessage(null);
            responseBean.setResult((Object)(user != null ? 1 : 0));
            status = Response.Status.OK;
        }
        catch (Exception e) {
            logger.error("Unable to retrieve such information", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }
}

