/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social.networking.ws.methods.v1;

import java.util.Iterator;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.utils.Caller;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portal.databook.shared.ApplicationProfile;
import org.gcube.portal.databook.shared.Feed;
import org.gcube.portal.databook.shared.FeedType;
import org.gcube.portal.social.networking.liferay.ws.GroupManagerWSBuilder;
import org.gcube.portal.social.networking.ws.utils.CassandraConnection;
import org.gcube.portal.social.networking.ws.utils.Filters;
import org.gcube.portal.social.networking.ws.utils.SocialUtils;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/posts")
@Deprecated
public class Posts {
    private static final Logger logger = LoggerFactory.getLogger(Posts.class);

    @GET
    @Path(value="getRecentPostsByUserAndDate/")
    @Produces(value={"application/json", "text/plain"})
    public Response getRecentPostsByUserAndDate(@QueryParam(value="time") long timeInMillis) {
        if (timeInMillis < 0L) {
            logger.error("Missing/wrong request parameters");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Missing request parameters.").build();
        }
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        String context = ScopeProvider.instance.get();
        List feeds = null;
        try {
            logger.info("Retrieving feeds for user id " + username + " and reference time " + timeInMillis);
            feeds = CassandraConnection.getInstance().getDatabookStore().getRecentFeedsByUserAndDate(username, timeInMillis);
            Filters.filterFeedsPerContext((List)feeds, (String)context);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve such feeds.", (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        logger.info("List retrieved");
        return Response.status((Response.Status)Response.Status.OK).entity((Object)feeds).build();
    }

    @GET
    @Path(value="getAllPostsByUser/")
    @Produces(value={"application/json", "text/plain"})
    public Response getAllPostsByUser() {
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        String context = ScopeProvider.instance.get();
        List feeds = null;
        try {
            logger.info("Retrieving feeds for user with id " + username);
            feeds = CassandraConnection.getInstance().getDatabookStore().getAllFeedsByUser(username);
            Filters.filterFeedsPerContext((List)feeds, (String)context);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve such feeds.", (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        logger.info("List retrieved");
        return Response.status((Response.Status)Response.Status.OK).entity((Object)feeds).build();
    }

    @GET
    @Path(value="getRecentPostsByUser/")
    @Produces(value={"application/json", "text/plain"})
    public Response getRecentPostsByUser(@DefaultValue(value="10") @QueryParam(value="quantity") int quantity) {
        if (quantity < 0) {
            logger.error("Missing/wrong request parameters");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Missing request parameters.").build();
        }
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        String context = ScopeProvider.instance.get();
        List feeds = null;
        if (quantity == 0) {
            return Response.status((Response.Status)Response.Status.OK).entity(feeds).build();
        }
        try {
            logger.info("Retrieving last " + quantity + " feeds made by user " + username);
            feeds = CassandraConnection.getInstance().getDatabookStore().getRecentFeedsByUser(username, -1);
            Filters.filterFeedsPerContext((List)feeds, (String)context);
            feeds = feeds.subList(0, quantity);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve such feeds.", (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        logger.info("List retrieved");
        return Response.status((Response.Status)Response.Status.OK).entity(feeds).build();
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="writePostUser")
    @Produces(value={"text/plain"})
    public Response writePostUser(@FormParam(value="text") String feedText, @FormParam(value="previewtitle") String previewTitle, @FormParam(value="previewdescription") String previewDescription, @FormParam(value="previewhost") String previewHost, @FormParam(value="previewurl") String previewUrl, @FormParam(value="httpimageurl") String httpImageUrl, @DefaultValue(value="false") @FormParam(value="enablenotification") String enableNotification) {
        logger.info("Request of writing a feed coming from user");
        if (feedText == null || feedText.isEmpty()) {
            logger.error("Missing request parameters");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Missing request parameters.").build();
        }
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        String context = ScopeProvider.instance.get();
        try {
            GroupManager groupManager = GroupManagerWSBuilder.getInstance().getGroupManager();
            long groupId = groupManager.getGroupIdFromInfrastructureScope(context);
            boolean isVRE = groupManager.isVRE(groupId);
            if (!isVRE) {
                logger.error("A post cannot be written into a context that is not a VRE");
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"A post cannot be written into a context that is not a VRE").build();
            }
            boolean notifyGroup = enableNotification.equals("true");
            if (notifyGroup) {
                logger.info("Enable notification for this user post.");
            } else {
                logger.info("Disable notification for this user post.");
            }
            logger.debug("Trying to share user feed...");
            Feed res = SocialUtils.shareUserUpdate((String)username, (String)feedText, (String)ScopeProvider.instance.get(), (String)previewTitle, (String)previewDescription, (String)previewHost, (String)previewUrl, (String)httpImageUrl, (boolean)notifyGroup);
            if (res != null) {
                logger.info("Feed correctly written by user " + username);
                return Response.status((Response.Status)Response.Status.CREATED).build();
            }
        }
        catch (Exception e) {
            logger.error("Feed not written by user " + username, (Throwable)e);
        }
        logger.info("Feed not written by user " + username);
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
    }

    @GET
    @Path(value="getAllPostsByApp/")
    @Produces(value={"application/json", "text/plain"})
    public Response getAllPostsByApp() {
        Caller caller = AuthorizationProvider.instance.get();
        String appId = caller.getClient().getId();
        String context = ScopeProvider.instance.get();
        ApplicationProfile appProfile = SocialUtils.getProfileFromInfrastrucure((String)appId, (String)ScopeProvider.instance.get());
        if (appProfile == null) {
            logger.error("The given token is not belonging to an application!!!");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"Invalid token: not belonging to an application.").build();
        }
        List feeds = null;
        try {
            logger.info("Retrieving feeds for app with id " + appId);
            feeds = CassandraConnection.getInstance().getDatabookStore().getAllFeedsByApp(appId);
            Filters.filterFeedsPerContext((List)feeds, (String)context);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve such feeds.", (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        logger.info("List retrieved");
        return Response.status((Response.Status)Response.Status.OK).entity((Object)feeds).build();
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="writePostApplication")
    @Produces(value={"text/plain"})
    public Response writePostApp(@FormParam(value="text") String feedText, @FormParam(value="params") String uriParams, @FormParam(value="previewtitle") String previewTitle, @FormParam(value="previewdescription") String previewDescription, @FormParam(value="httpimageurl") String httpImageUrl, @DefaultValue(value="false") @FormParam(value="enablenotification") String enableNotification) {
        logger.info("Request of writing a feed coming from an application.");
        if (feedText == null || feedText.isEmpty()) {
            logger.error("Missing request parameters");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Missing request parameters.").build();
        }
        Caller caller = AuthorizationProvider.instance.get();
        String appId = caller.getClient().getId();
        String context = ScopeProvider.instance.get();
        try {
            GroupManager groupManager = GroupManagerWSBuilder.getInstance().getGroupManager();
            long groupId = groupManager.getGroupIdFromInfrastructureScope(context);
            boolean isVRE = groupManager.isVRE(groupId);
            if (!isVRE) {
                logger.error("A post cannot be written into a context that is not a VRE");
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"A post cannot be written into a context that is not a VRE").build();
            }
            ApplicationProfile appProfile = SocialUtils.getProfileFromInfrastrucure((String)appId, (String)ScopeProvider.instance.get());
            if (appProfile == null) {
                logger.error("The given token doesn't belong to an application!!!");
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"Invalid token: not belonging to an application.").build();
            }
            boolean notifyGroup = enableNotification.equals("true");
            if (notifyGroup) {
                logger.info("Enable notification for this application post.");
            } else {
                logger.info("Disable notification for this application post.");
            }
            Feed written = SocialUtils.shareApplicationUpdate((String)feedText, (String)uriParams, (String)previewTitle, (String)previewDescription, (String)httpImageUrl, (ApplicationProfile)appProfile, (Caller)caller, (boolean)notifyGroup);
            if (written != null) {
                return Response.status((Response.Status)Response.Status.CREATED).build();
            }
        }
        catch (Exception e) {
            logger.error("Error while writing a post", (Throwable)e);
        }
        logger.info("Feed not written by application " + appId);
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
    }

    @GET
    @Path(value="getAllPostsByVRE/")
    @Produces(value={"application/json", "text/plain"})
    public Response getAllPostsByVRE() {
        String scope = ScopeProvider.instance.get();
        logger.info("Retrieving all posts coming from vre = " + scope);
        List feeds = null;
        try {
            feeds = CassandraConnection.getInstance().getDatabookStore().getAllFeedsByVRE(scope);
            Iterator it = feeds.iterator();
            while (it.hasNext()) {
                Feed f = (Feed)it.next();
                if (f.getType() != FeedType.DISABLED) continue;
                it.remove();
            }
        }
        catch (Exception e) {
            logger.error("Unable to retrieve feeds for vre = " + scope, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        logger.info("List of feeds of vre = " + scope + " retrieved");
        return Response.status((Response.Status)Response.Status.OK).entity((Object)feeds).build();
    }

    @GET
    @Path(value="getAllLikedPostIdsByUser/")
    @Produces(value={"application/json", "text/plain"})
    public Response getAllLikedPostIdsByUser() {
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        logger.info("Retrieving all liked feeds IDS for user with id " + username);
        List retrievedLikedFeeds = null;
        try {
            retrievedLikedFeeds = CassandraConnection.getInstance().getDatabookStore().getAllLikedFeedIdsByUser(username);
        }
        catch (Exception e) {
            logger.error("Unable to read such ids of liked feeds.", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        logger.info("Ids of liked feeds by " + username + " retrieved");
        return Response.status((Response.Status)Response.Status.OK).entity((Object)retrievedLikedFeeds).build();
    }

    @GET
    @Path(value="getAllLikedPostsByUser/")
    @Produces(value={"application/json", "text/plain"})
    public Response getAllLikedPostsByUser(@DefaultValue(value="10") @QueryParam(value="limit") int limit) {
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        logger.info("Retrieving " + limit + " liked feeds for user with id " + username);
        List retrievedLikedFeeds = null;
        try {
            retrievedLikedFeeds = CassandraConnection.getInstance().getDatabookStore().getAllLikedFeedsByUser(username, limit);
        }
        catch (Exception e) {
            logger.error("Unable to read such liked feeds.", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        logger.info("Liked feeds by " + username + " retrieved");
        return Response.status((Response.Status)Response.Status.OK).entity((Object)retrievedLikedFeeds).build();
    }
}

