/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social.networking.ws.methods.v1;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.utils.Caller;
import org.gcube.portal.social.networking.liferay.ws.UserManagerWSBuilder;
import org.gcube.portal.social.networking.ws.utils.TokensUtils;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/users")
@Deprecated
public class Users {
    private static final Logger logger = LoggerFactory.getLogger(Users.class);
    private static final String NOT_USER_TOKEN_CONTEXT_USED = "User's information can only be retrieved through a user token (not qualified)";

    @GET
    @Path(value="readCustomAttr/")
    @Produces(value={"text/plain"})
    public Response readCustomAttr(@QueryParam(value="attribute") String attributeKey) {
        String toReturn;
        if (attributeKey == null || attributeKey.isEmpty()) {
            logger.error("Missing/wrong request parameters");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Missing request parameters.").build();
        }
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        if (!TokensUtils.isUserTokenDefault((Caller)caller)) {
            logger.warn(NOT_USER_TOKEN_CONTEXT_USED);
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"User's information can only be retrieved through a user token").build();
        }
        try {
            GCubeUser user = UserManagerWSBuilder.getInstance().getUserManager().getUserByUsername(username);
            toReturn = (String)((Object)UserManagerWSBuilder.getInstance().getUserManager().readCustomAttr(user.getUserId(), attributeKey));
        }
        catch (Exception e) {
            logger.error("Unable to retrieve attribute for user.", (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        logger.info("Attribute " + attributeKey + " retrieved for user " + username);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)toReturn).build();
    }

    @GET
    @Path(value="getUserFullname")
    @Produces(value={"text/plain"})
    public Response getUserUsername() {
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        String toReturn = null;
        if (!TokensUtils.isUserTokenDefault((Caller)caller)) {
            logger.warn(NOT_USER_TOKEN_CONTEXT_USED);
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"User's information can only be retrieved through a user token").build();
        }
        try {
            GCubeUser user = UserManagerWSBuilder.getInstance().getUserManager().getUserByUsername(username);
            toReturn = user.getFullname();
            logger.info("Found fullname " + toReturn + " for user " + username);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve attribute for user.", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.toString()).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)toReturn).build();
    }

    @GET
    @Path(value="getUserEmail")
    @Produces(value={"text/plain"})
    public Response getUserEmail() {
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        String toReturn = null;
        if (!TokensUtils.isUserTokenDefault((Caller)caller)) {
            logger.warn(NOT_USER_TOKEN_CONTEXT_USED);
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"User's information can only be retrieved through a user token").build();
        }
        try {
            GCubeUser user = UserManagerWSBuilder.getInstance().getUserManager().getUserByUsername(username);
            toReturn = user.getEmail();
            logger.info("Found email " + toReturn + " for user " + username);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve attribute for user.", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.toString()).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)toReturn).build();
    }
}

