/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social.networking.ws.methods.v2;

import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.ValidationException;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.utils.Caller;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portal.databook.shared.ApplicationProfile;
import org.gcube.portal.databook.shared.Feed;
import org.gcube.portal.social.networking.ws.utils.CassandraConnection;
import org.gcube.portal.social.networking.ws.utils.Filters;
import org.gcube.portal.social.networking.ws.utils.SocialUtils;
import org.gcube.social_networking.socialnetworking.model.beans.PostInputBean;
import org.gcube.social_networking.socialnetworking.model.output.ResponseBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="2/posts")
public class Posts {
    private static final Logger logger = LoggerFactory.getLogger(Posts.class);

    @GET
    @Path(value="get-posts-user-since/")
    @Produces(value={"application/json"})
    public Response getRecentPostsByUserAndDate(@QueryParam(value="time") @Min(value=0L, message="time cannot be negative") long timeInMillis) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        Caller caller = AuthorizationProvider.instance.get();
        String context = ScopeProvider.instance.get();
        String username = caller.getClient().getId();
        List feeds = null;
        try {
            logger.info("Retrieving feeds for user id " + username + " and reference time " + timeInMillis);
            feeds = CassandraConnection.getInstance().getDatabookStore().getRecentFeedsByUserAndDate(username, timeInMillis);
            Filters.filterFeedsPerContext((List)feeds, (String)context);
            Filters.hideSensitiveInformation((List)feeds, (String)caller.getClient().getId());
            responseBean.setResult((Object)feeds);
            responseBean.setMessage("");
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve such feeds.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Path(value="get-posts-user/")
    @Produces(value={"application/json"})
    public Response getAllPostsByUser() {
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        String context = ScopeProvider.instance.get();
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        List feeds = null;
        try {
            logger.debug("Retrieving feeds for user with id " + username);
            feeds = CassandraConnection.getInstance().getDatabookStore().getAllFeedsByUser(username);
            Filters.filterFeedsPerContext((List)feeds, (String)context);
            Filters.hideSensitiveInformation((List)feeds, (String)caller.getClient().getId());
            responseBean.setResult((Object)feeds);
            responseBean.setMessage("");
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve such feeds.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Path(value="get-posts-user-quantity/")
    @Produces(value={"application/json"})
    public Response getQuantityPostsByUser(@DefaultValue(value="10") @QueryParam(value="quantity") @Min(value=0L, message="quantity cannot be negative") int quantity) throws ValidationException {
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        String context = ScopeProvider.instance.get();
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        List feeds = new ArrayList();
        if (quantity <= 0) {
            responseBean.setSuccess(true);
            return Response.status((Response.Status)status).entity((Object)responseBean).build();
        }
        try {
            logger.debug("Retrieving last " + quantity + " feeds made by user " + username);
            feeds = CassandraConnection.getInstance().getDatabookStore().getRecentFeedsByUser(username, quantity);
            Filters.filterFeedsPerContext(feeds, (String)context);
            feeds = feeds.subList(0, quantity);
            Filters.hideSensitiveInformation(feeds, (String)caller.getClient().getId());
            responseBean.setResult(feeds);
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve such feeds.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @POST
    @Path(value="write-post-user")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response writePostUser(@NotNull(message="Post to write is missing") @Valid PostInputBean post) throws ValidationException {
        logger.debug("Request of writing a feed coming from user " + post);
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        String context = ScopeProvider.instance.get();
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.CREATED;
        String feedText = post.getText();
        String previewTitle = post.getPreviewtitle();
        String previewDescription = post.getPreviewdescription();
        String previewHost = post.getPreviewhost();
        String previewUrl = post.getPreviewurl();
        String httpImageUrl = post.getHttpimageurl();
        boolean enableNotification = post.isEnablenotification();
        if (enableNotification) {
            logger.info("Enable notification for this user post.");
        } else {
            logger.info("Disable notification for this user post.");
        }
        logger.debug("Trying to share user feed...");
        Feed res = SocialUtils.shareUserUpdate((String)username, (String)feedText, (String)context, (String)previewTitle, (String)previewDescription, (String)previewHost, (String)previewUrl, (String)httpImageUrl, (boolean)enableNotification);
        if (res != null) {
            logger.debug("Feed correctly written by user " + username);
            responseBean.setResult((Object)res);
            responseBean.setSuccess(true);
            return Response.status((Response.Status)status).entity((Object)responseBean).build();
        }
        logger.error("Unable to write post.");
        responseBean.setMessage("Unable to write post");
        responseBean.setSuccess(false);
        status = Response.Status.INTERNAL_SERVER_ERROR;
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Path(value="get-posts-app/")
    @Produces(value={"application/json"})
    public Response getAllPostsByApp() {
        Caller caller = AuthorizationProvider.instance.get();
        String appId = caller.getClient().getId();
        String context = ScopeProvider.instance.get();
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        ApplicationProfile appProfile = SocialUtils.getProfileFromInfrastrucure((String)appId, (String)context);
        if (appProfile == null) {
            logger.error("The given token is not belonging to an application!!!");
            status = Response.Status.FORBIDDEN;
            responseBean.setSuccess(false);
            responseBean.setMessage("Invalid token: not belonging to an application.");
            return Response.status((Response.Status)status).entity((Object)responseBean).build();
        }
        try {
            logger.debug("Retrieving feeds for app with id " + appId);
            List feeds = CassandraConnection.getInstance().getDatabookStore().getAllFeedsByApp(appId);
            Filters.filterFeedsPerContext((List)feeds, (String)context);
            responseBean.setSuccess(true);
            responseBean.setResult((Object)feeds);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve such feeds.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @POST
    @Path(value="write-post-app")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response writePostApp(@NotNull(message="Post to write is null") @Valid PostInputBean post) {
        Caller caller = AuthorizationProvider.instance.get();
        String appId = caller.getClient().getId();
        String context = ScopeProvider.instance.get();
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.CREATED;
        logger.debug("Request of writing a feed coming from an application.");
        ApplicationProfile appProfile = SocialUtils.getProfileFromInfrastrucure((String)appId, (String)context);
        if (appProfile == null) {
            logger.error("The given token doesn't belong to an application!!!");
            responseBean.setSuccess(false);
            responseBean.setMessage("Invalid token: not belonging to an application.");
            status = Response.Status.FORBIDDEN;
            return Response.status((Response.Status)status).entity((Object)responseBean).build();
        }
        String feedText = post.getText();
        String previewTitle = post.getPreviewtitle();
        String previewDescription = post.getPreviewdescription();
        String httpImageUrl = post.getHttpimageurl();
        boolean enableNotification = post.isEnablenotification();
        String params = post.getParams();
        if (enableNotification) {
            logger.debug("Enable notification for this application post.");
        } else {
            logger.debug("Disable notification for this application post.");
        }
        Feed written = SocialUtils.shareApplicationUpdate((String)feedText, (String)params, (String)previewTitle, (String)previewDescription, (String)httpImageUrl, (ApplicationProfile)appProfile, (Caller)caller, (boolean)enableNotification);
        if (written != null) {
            responseBean.setResult((Object)written);
            responseBean.setSuccess(true);
            return Response.status((Response.Status)status).entity((Object)responseBean).build();
        }
        logger.error("Unable to write post.");
        responseBean.setMessage("Unable to write post");
        responseBean.setSuccess(false);
        status = Response.Status.INTERNAL_SERVER_ERROR;
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Path(value="get-posts-vre/")
    @Produces(value={"application/json"})
    public Response getAllPostsByVRE() {
        String scope = ScopeProvider.instance.get();
        Caller caller = AuthorizationProvider.instance.get();
        logger.debug("Retrieving all posts coming from vre = " + scope);
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            List feeds = CassandraConnection.getInstance().getDatabookStore().getAllFeedsByVRE(scope);
            Filters.hideSensitiveInformation((List)feeds, (String)caller.getClient().getId());
            responseBean.setResult((Object)feeds);
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve feeds for vre = " + scope, (Throwable)e);
            status = Response.Status.INTERNAL_SERVER_ERROR;
            responseBean.setMessage(e.toString());
            responseBean.setSuccess(false);
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Path(value="get-posts-by-hashtag/")
    @Produces(value={"application/json"})
    public Response getPostsByHashTags(@QueryParam(value="hashtag") @NotNull(message="hashtag cannot be missing") String hashtag) throws ValidationException {
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        String context = ScopeProvider.instance.get();
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        logger.info("User " + username + " has requested posts containing hashtag " + hashtag + " in context " + context);
        try {
            DatabookStore datastore = CassandraConnection.getInstance().getDatabookStore();
            List feeds = datastore.getVREFeedsByHashtag(context, hashtag);
            Filters.hideSensitiveInformation((List)feeds, (String)caller.getClient().getId());
            responseBean.setResult((Object)feeds);
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Failed to retrieve hashtags", (Throwable)e);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Path(value="get-id-liked-posts/")
    @Produces(value={"application/json"})
    public Response getAllLikedPostIdsByUser() {
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        String context = ScopeProvider.instance.get();
        logger.debug("Retrieving all liked feeds for user with id " + username + " in context " + context);
        List retrievedLikedFeedsIds = null;
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            DatabookStore datastore = CassandraConnection.getInstance().getDatabookStore();
            retrievedLikedFeedsIds = datastore.getAllLikedFeedIdsByUser(username);
            Filters.filterFeedsPerContextById((List)retrievedLikedFeedsIds, (String)context);
            responseBean.setResult((Object)retrievedLikedFeedsIds);
            responseBean.setSuccess(true);
            logger.debug("Ids of liked feeds by " + username + " retrieved");
        }
        catch (Exception e) {
            logger.error("Unable to read such ids of liked feeds.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Path(value="get-liked-posts/")
    @Produces(value={"application/json"})
    public Response getAllLikedPostsByUser(@DefaultValue(value="10") @QueryParam(value="limit") @Min(message="limit cannot be negative", value=0L) int limit) throws ValidationException {
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        String context = ScopeProvider.instance.get();
        List retrievedLikedFeeds = null;
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            logger.debug("Retrieving " + limit + " liked feeds for user with id " + username + " in context " + context);
            retrievedLikedFeeds = CassandraConnection.getInstance().getDatabookStore().getAllLikedFeedsByUser(username, limit);
            Filters.filterFeedsPerContext((List)retrievedLikedFeeds, (String)context);
            Filters.hideSensitiveInformation((List)retrievedLikedFeeds, (String)caller.getClient().getId());
            responseBean.setResult((Object)retrievedLikedFeeds);
            responseBean.setSuccess(true);
            logger.debug("Liked feeds by " + username + " retrieved");
        }
        catch (Exception e) {
            logger.error("Unable to read such liked feeds.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }
}

