/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social.networking.ws.methods.v2;

import java.util.Arrays;
import java.util.List;
import javax.validation.Valid;
import javax.validation.ValidationException;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.gcube.applicationsupportlayer.social.ApplicationNotificationsManager;
import org.gcube.applicationsupportlayer.social.NotificationsManager;
import org.gcube.applicationsupportlayer.social.shared.SocialNetworkingSite;
import org.gcube.applicationsupportlayer.social.shared.SocialNetworkingUser;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.utils.Caller;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portal.notifications.bean.GenericItemBean;
import org.gcube.portal.notifications.thread.JobStatusNotificationThread;
import org.gcube.portal.social.networking.caches.SocialNetworkingSiteFinder;
import org.gcube.portal.social.networking.liferay.ws.LiferayJSONWsCredentials;
import org.gcube.portal.social.networking.liferay.ws.UserManagerWSBuilder;
import org.gcube.portal.social.networking.ws.utils.CassandraConnection;
import org.gcube.social_networking.socialnetworking.model.beans.JobNotificationBean;
import org.gcube.social_networking.socialnetworking.model.output.ResponseBean;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="2/notifications")
public class Notifications {
    private static final Logger logger = LoggerFactory.getLogger(Notifications.class);

    @GET
    @Path(value="get-range-notifications/")
    @Produces(value={"application/json"})
    public Response getRangeNotifications(@DefaultValue(value="1") @QueryParam(value="from") @Min(value=1L, message="from must be greater or equal to 1") int from, @DefaultValue(value="10") @QueryParam(value="quantity") @Min(value=0L, message="quantity must be greater or equal to 0") int quantity) throws ValidationException {
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        logger.debug("Retrieving " + quantity + " notifications of user = " + username + " from " + from);
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        List notifications = null;
        try {
            notifications = CassandraConnection.getInstance().getDatabookStore().getRangeNotificationsByUser(username, from, quantity);
            responseBean.setResult((Object)notifications);
            responseBean.setSuccess(true);
            logger.debug("List of notifications retrieved");
        }
        catch (Exception e) {
            logger.error("Unable to retrieve such notifications.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @POST
    @Path(value="notify-job-status/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response notifyJobStatus(@NotNull(message="input is missing") @Valid JobNotificationBean job) throws ValidationException {
        Caller caller = AuthorizationProvider.instance.get();
        String context = ScopeProvider.instance.get();
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        String appQualifier = caller.getClient().getId();
        logger.info("Received request from app " + appQualifier + " to notify job status described by bean " + job);
        try {
            String recipient = job.getRecipient();
            GCubeUser userRecipient = UserManagerWSBuilder.getInstance().getUserManager().getUserByUsername(recipient);
            GenericItemBean recipientBean = new GenericItemBean(userRecipient.getUsername(), userRecipient.getUsername(), userRecipient.getFullname(), userRecipient.getUserAvatarURL());
            SocialNetworkingSite site = SocialNetworkingSiteFinder.getSocialNetworkingSiteFromScope((String)context);
            GCubeUser senderUser = UserManagerWSBuilder.getInstance().getUserManager().getUserByEmail(LiferayJSONWsCredentials.getSingleton().getUser());
            SocialNetworkingUser user = new SocialNetworkingUser(senderUser.getUsername(), senderUser.getEmail(), senderUser.getFullname(), senderUser.getUserAvatarURL());
            ApplicationNotificationsManager nm = new ApplicationNotificationsManager(UserManagerWSBuilder.getInstance().getUserManager(), site, context, user);
            new Thread((Runnable)new JobStatusNotificationThread(job.getRunningJob(), Arrays.asList(recipientBean), (NotificationsManager)nm)).start();
            responseBean.setSuccess(true);
            responseBean.setResult((Object)"Notification thread started");
        }
        catch (Exception e) {
            logger.error("Unable to send job notification", (Throwable)e);
            responseBean.setSuccess(false);
            responseBean.setMessage(e.getMessage());
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }
}

