/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social.networking.ws.methods.v2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.ValidationException;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.gcube.applicationsupportlayer.social.ApplicationNotificationsManager;
import org.gcube.applicationsupportlayer.social.NotificationsManager;
import org.gcube.applicationsupportlayer.social.shared.SocialNetworkingSite;
import org.gcube.applicationsupportlayer.social.shared.SocialNetworkingUser;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.authorization.library.utils.Caller;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.sharing.WorkspaceMessage;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portal.notifications.bean.GenericItemBean;
import org.gcube.portal.notifications.thread.MessageNotificationsThread;
import org.gcube.portal.social.networking.caches.SocialNetworkingSiteFinder;
import org.gcube.portal.social.networking.liferay.ws.LiferayJSONWsCredentials;
import org.gcube.portal.social.networking.liferay.ws.UserManagerWSBuilder;
import org.gcube.portal.social.networking.ws.utils.TokensUtils;
import org.gcube.social_networking.socialnetworking.model.beans.Message;
import org.gcube.social_networking.socialnetworking.model.beans.Recipient;
import org.gcube.social_networking.socialnetworking.model.output.ResponseBean;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.exception.UserRetrievalFault;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="2/messages")
public class Messages {
    private static final Logger logger = LoggerFactory.getLogger(Messages.class);
    private static final Function<WorkspaceMessage, Message> WORKSPACE_MESSAGE_TO_MESSAGE = new /* Unavailable Anonymous Inner Class!! */;

    @POST
    @Path(value="write-message/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response writeMessage(@NotNull(message="Message to send is missing") @Valid Message input, @Context HttpServletRequest httpServletRequest) throws ValidationException, UserManagementSystemException, UserRetrievalFault {
        logger.debug("Incoming message bean is " + input);
        Caller caller = AuthorizationProvider.instance.get();
        String senderId = null;
        if (!TokensUtils.isUserToken((Caller)caller)) {
            GCubeUser jarvis = UserManagerWSBuilder.getInstance().getUserManager().getUserByEmail(LiferayJSONWsCredentials.getSingleton().getUser());
            SecurityTokenProvider.instance.set(LiferayJSONWsCredentials.getSingleton().getNotifierUserToken());
            senderId = jarvis.getUsername();
        } else {
            senderId = caller.getClient().getId();
        }
        String scope = ScopeProvider.instance.get();
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.CREATED;
        String body = input.getBody();
        String subject = input.getSubject();
        List recipientsIds = input.getRecipients();
        logger.info("Sender is going to be the token's owner [" + senderId + "]");
        ArrayList<String> recipientsListFiltered = new ArrayList<String>();
        ArrayList<GenericItemBean> recipientsBeans = new ArrayList<GenericItemBean>();
        for (Recipient recipientId : recipientsIds) {
            try {
                String tempId = recipientId.getId().trim();
                if (tempId.isEmpty()) continue;
                GCubeUser userRecipient = UserManagerWSBuilder.getInstance().getUserManager().getUserByUsername(tempId);
                if (userRecipient == null) {
                    userRecipient = UserManagerWSBuilder.getInstance().getUserManager().getUserByEmail(tempId);
                }
                if (userRecipient == null) continue;
                GenericItemBean beanUser = new GenericItemBean(userRecipient.getUsername(), userRecipient.getUsername(), userRecipient.getFullname(), userRecipient.getUserAvatarURL());
                recipientsBeans.add(beanUser);
                recipientsListFiltered.add(userRecipient.getUsername());
            }
            catch (Exception e) {
                logger.error("Unable to retrieve recipient information for recipient with id " + recipientId, (Throwable)e);
            }
        }
        if (recipientsListFiltered.isEmpty()) {
            logger.error("Missing/wrong request parameters");
            status = Response.Status.BAD_REQUEST;
            responseBean.setMessage("Missing request parameters.");
            return Response.status((Response.Status)status).entity((Object)responseBean).build();
        }
        try {
            logger.debug("Trying to send message with body " + body + " subject " + subject + " to users " + recipientsIds + " from " + senderId);
            GCubeUser senderUser = UserManagerWSBuilder.getInstance().getUserManager().getUserByUsername(senderId);
            Workspace workspace = HomeLibrary.getUserWorkspace((String)senderId);
            logger.debug("Workspace is " + workspace.getRoot());
            logger.debug("Sending message to " + recipientsListFiltered);
            String messageId = workspace.getWorkspaceMessageManager().sendMessageToPortalLogins(subject, body, new ArrayList(), recipientsListFiltered);
            logger.debug("Message sent to " + recipientsIds + ". Sending message notification to: " + recipientsIds);
            SocialNetworkingSite site = SocialNetworkingSiteFinder.getSocialNetworkingSiteFromScope((String)scope);
            SocialNetworkingUser user = new SocialNetworkingUser(senderUser.getUsername(), senderUser.getEmail(), senderUser.getFullname(), senderUser.getUserAvatarURL());
            ApplicationNotificationsManager nm = new ApplicationNotificationsManager(UserManagerWSBuilder.getInstance().getUserManager(), site, ScopeProvider.instance.get(), user);
            new Thread((Runnable)new MessageNotificationsThread(recipientsBeans, messageId, subject, body, (NotificationsManager)nm)).start();
            responseBean.setSuccess(true);
            responseBean.setResult((Object)messageId);
        }
        catch (Exception e) {
            logger.error("Unable to send message.", (Throwable)e);
            status = Response.Status.INTERNAL_SERVER_ERROR;
            responseBean.setMessage(e.getMessage());
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Path(value="get-sent-messages")
    @Produces(value={"application/json"})
    public Response getSentMessages() {
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        logger.info("Request for retrieving sent messages by " + username);
        try {
            Workspace workspace = HomeLibrary.getUserWorkspace((String)username);
            List sentMessages = workspace.getWorkspaceMessageManager().getSentMessages();
            Collections.reverse(sentMessages);
            List mappedMessages = sentMessages.stream().map(WORKSPACE_MESSAGE_TO_MESSAGE).collect(Collectors.toList());
            responseBean.setSuccess(true);
            logger.debug("Result is " + mappedMessages);
            responseBean.setResult(mappedMessages);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve sent messages", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Path(value="get-received-messages")
    @Produces(value={"application/json"})
    public Response getReceivedMessages() {
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        logger.info("Request for retrieving received messages by " + username);
        try {
            Workspace workspace = HomeLibrary.getUserWorkspace((String)username);
            List getMessages = workspace.getWorkspaceMessageManager().getReceivedMessages();
            Collections.reverse(getMessages);
            List mappedMessages = getMessages.stream().map(WORKSPACE_MESSAGE_TO_MESSAGE).collect(Collectors.toList());
            responseBean.setSuccess(true);
            responseBean.setResult(mappedMessages);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve sent messages", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

