package org.gcube.portal.social.networking.ws.methods.v2;


import java.util.List;

import javax.validation.ValidationException;
import javax.validation.constraints.Min;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;

import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.utils.Caller;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portal.databook.shared.Comment;
import org.gcube.portal.social.networking.ws.utils.CassandraConnection;
import org.gcube.portal.social.networking.ws.utils.Filters;
import org.gcube.social_networking.socialnetworking.model.output.ResponseBean;
import org.slf4j.LoggerFactory;

/**
 * REST interface for the social networking library (comments).
 * @author Costantino Perciante at ISTI-CNR
 */
@Path("2/comments")
/**
 * Resource endpoint for Comment (version 2)
 * @author Costantino Perciante at ISTI-CNR 
 * (costantino.perciante@isti.cnr.it)
 */
public class Comments {

	// Logger
	private static final org.slf4j.Logger logger = LoggerFactory.getLogger(Comments.class);

	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("get-comments-user")
	public Response getCommentsUser() {

		ResponseBean<List<Comment>> responseBean = new ResponseBean<List<Comment>>();
		Status status = Status.OK;
		Caller caller = AuthorizationProvider.instance.get();
		String context = ScopeProvider.instance.get();
		String username = caller.getClient().getId();
		List<Comment> comments = null;

		try{
			logger.info("Retrieving comments for user id " + username);
			comments = CassandraConnection.getInstance().getDatabookStore().getRecentCommentsByUserAndDate(username, 0);
			Filters.filterCommentsPerContext(comments, context);
			responseBean.setResult(comments);
			responseBean.setSuccess(true);
		}catch(Exception e){
			logger.error("Unable to retrieve such comments.", e);
			responseBean.setMessage(e.getMessage());
			responseBean.setSuccess(false);
			status = Status.INTERNAL_SERVER_ERROR;
		}

		return Response.status(status).entity(responseBean).build();
	}

	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("get-comments-user-by-time")
	public Response getCommentsUserByTime(
			@QueryParam("time") 
			@Min(value = 0, message="time cannot be negative") 
			long timeInMillis
			) throws ValidationException{

		ResponseBean<List<Comment>> responseBean = new ResponseBean<List<Comment>>();
		Status status = Status.OK;
		Caller caller = AuthorizationProvider.instance.get();
		String context = ScopeProvider.instance.get();
		String username = caller.getClient().getId();
		List<Comment> comments = null;

		try{
			logger.info("Retrieving comments for user id " + username);
			comments = CassandraConnection.getInstance().getDatabookStore().getRecentCommentsByUserAndDate(username, timeInMillis);
			Filters.filterCommentsPerContext(comments, context);
			responseBean.setResult(comments);
			responseBean.setMessage("");
			responseBean.setSuccess(true);
		}catch(Exception e){
			logger.error("Unable to retrieve such comments.", e);
			responseBean.setMessage(e.getMessage());
			responseBean.setSuccess(false);
			status = Status.INTERNAL_SERVER_ERROR;
		}

		return Response.status(status).entity(responseBean).build();
	}
}
