package org.gcube.portal.social.networking.ws.methods.v2;

import java.util.ArrayList;
import java.util.List;

import javax.validation.ValidationException;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;

import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.utils.Caller;
import org.gcube.portal.social.networking.liferay.ws.GroupManagerWSBuilder;
import org.gcube.portal.social.networking.liferay.ws.RoleManagerWSBuilder;
import org.gcube.portal.social.networking.liferay.ws.UserManagerWSBuilder;
import org.gcube.portal.social.networking.ws.utils.TokensUtils;
import org.gcube.social_networking.socialnetworking.model.beans.MyVRE;
import org.gcube.social_networking.socialnetworking.model.beans.VREManager;
import org.gcube.social_networking.socialnetworking.model.output.ResponseBean;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.RoleManager;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeGroup;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.gcube.vomanagement.usermanagement.model.GatewayRolesNames;
import org.slf4j.LoggerFactory;


/**
 * REST interface for the social networking library (vres).
 * @author Costantino Perciante at ISTI-CNR
 */
@Path("2/vres")
public class VREs {

	// Logger
	private static final org.slf4j.Logger logger = LoggerFactory.getLogger(Users.class);

	@GET
	@Path("get-my-vres/")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getMyVres(
			@DefaultValue("false") @QueryParam("getManagers") boolean getManagers
			) throws ValidationException {

		Caller caller = AuthorizationProvider.instance.get();
		String username = caller.getClient().getId();
		ResponseBean<List<MyVRE>> responseBean = new ResponseBean<List<MyVRE>>();
		Status status = Status.OK;

		if(!TokensUtils.isUserToken(caller)){
			status = Status.FORBIDDEN;
			responseBean.setMessage("This method can only be invoked with a user token!");
			logger.warn("Trying to access get-my-vres method via a token different than USER is not allowed");
		}else{
			GroupManager gmManager = GroupManagerWSBuilder.getInstance().getGroupManager();
			UserManager userManager = UserManagerWSBuilder.getInstance().getUserManager();
			RoleManager roleManager = RoleManagerWSBuilder.getInstance().getRoleManager();
			try{

				GCubeUser user = userManager.getUserByUsername(username);
				List<GCubeGroup> vres = gmManager.listVresByUser(user.getUserId());
				List<MyVRE> toReturn = new ArrayList<MyVRE>();

				for (GCubeGroup group : vres) {

					// # ticket 9333
					String name = group.getGroupName();
					String context = gmManager.getInfrastructureScope(group.getGroupId());
					String description = group.getDescription();
					List<VREManager> managers = new ArrayList<VREManager>();

					if(getManagers){
						List<GCubeUser> vreManagers = userManager.listUsersByGroupAndRole(group.getGroupId(), 
								roleManager.getRoleIdByName(GatewayRolesNames.VRE_MANAGER.getRoleName()));

						for (GCubeUser vreManager : vreManagers) {
							VREManager manager = new VREManager();
							manager.setUsername(vreManager.getUsername());
							manager.setFullname(vreManager.getFullname());
							managers.add(manager);
						}
					}
					
					MyVRE myVre = new MyVRE(description, name, context);
					myVre.setManagers(managers);
					toReturn.add(myVre);
				}

				responseBean.setSuccess(true);
				responseBean.setResult(toReturn);

			}catch(Exception e){

				logger.error("Unable to retrieve vres for user.", e);
				responseBean.setMessage(e.toString());
				responseBean.setSuccess(false);
				status = Status.INTERNAL_SERVER_ERROR;

			}
		}
		return Response.status(status).entity(responseBean).build();
	}	
}
