package org.gcube.portal.social.networking.ws.ex;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

import org.gcube.social_networking.socialnetworking.model.output.ResponseBean;
import org.slf4j.LoggerFactory;


/**
 * Exception thrown when @Valid fail
 * @author Costantino Perciante at ISTI-CNR
 */
@Provider //remove to make it discoverable by jersey at runtime
public class ApplicationException implements ExceptionMapper<Exception> {

	private static final org.slf4j.Logger logger = LoggerFactory.getLogger(ApplicationException.class);

	public Response toResponse(Exception e) {
		logger.warn("ApplicationException invoked for exception ", e);
		return Response
				.status(Response.Status.OK.getStatusCode())
				.type(MediaType.APPLICATION_JSON)
				.entity(new ResponseBean<Void>(false, e.toString(), null))
				.build();
	}
}