/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social.networking.ws.methods.v2;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.utils.Caller;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portal.social.networking.liferay.ws.GroupManagerWSBuilder;
import org.gcube.portal.social.networking.liferay.ws.RoleManagerWSBuilder;
import org.gcube.portal.social.networking.liferay.ws.UserManagerWSBuilder;
import org.gcube.portal.social.networking.ws.outputs.ResponseBean;
import org.gcube.portal.social.networking.ws.utils.Utils;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.RoleManager;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeRole;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="2/people")
@Api(value="people", authorizations={@Authorization(value="gcube-token-query"), @Authorization(value="gcube-token-header")})
public class People {
    private static final Logger logger = LoggerFactory.getLogger(People.class);

    @GET
    @Path(value="profile")
    @ApiOperation(value="Retrieve user's profile", notes="Retrieve the user's profile. The user in this case is the one bound to the token which can be of any kind (qualified, default)", response=ResponseBean.class, nickname="profile")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful retrieval of user's profile, reported in the 'result' field of the returned object", response=ResponseBean.class), @ApiResponse(code=500, message="The error is reported into the 'message' field of the returned object", response=ResponseBean.class)})
    @Produces(value={"application/json"})
    public Response getProfile() {
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        GCubeUser user = null;
        String scope = ScopeProvider.instance.get();
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        if (!Utils.isUserToken((Caller)caller)) {
            status = Response.Status.FORBIDDEN;
            responseBean.setMessage("User's information can only be retrieved through a user token");
            logger.warn("Trying to access users method via a token different than 'user-token' is not allowed");
        } else {
            try {
                UserManager userManager = UserManagerWSBuilder.getInstance().getUserManager();
                RoleManager roleManager = RoleManagerWSBuilder.getInstance().getRoleManager();
                GroupManager groupManager = GroupManagerWSBuilder.getInstance().getGroupManager();
                user = userManager.getUserByUsername(username);
                HashMap<String, Object> toReturn = new HashMap<String, Object>();
                toReturn.put("username", user.getUsername());
                toReturn.put("avatar", user.getUserAvatarURL());
                toReturn.put("fullname", user.getFullname());
                List roles = roleManager.listRolesByUserAndGroup(user.getUserId(), groupManager.getGroupIdFromInfrastructureScope(scope));
                ArrayList<String> rolesNames = new ArrayList<String>();
                for (GCubeRole gCubeRole : roles) {
                    rolesNames.add(gCubeRole.getRoleName());
                }
                toReturn.put("roles", rolesNames);
                responseBean.setResult(toReturn);
                responseBean.setSuccess(true);
            }
            catch (Exception e) {
                logger.error("Unable to retrieve user's profile", (Throwable)e);
                responseBean.setMessage(e.getMessage());
                status = Response.Status.INTERNAL_SERVER_ERROR;
            }
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }
}

