/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social.networking.ws.utils;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gcube.applicationsupportlayer.social.ApplicationNotificationsManager;
import org.gcube.applicationsupportlayer.social.NotificationsManager;
import org.gcube.applicationsupportlayer.social.ex.ApplicationProfileNotFoundException;
import org.gcube.applicationsupportlayer.social.shared.SocialNetworkingSite;
import org.gcube.applicationsupportlayer.social.shared.SocialNetworkingUser;
import org.gcube.common.authorization.library.utils.Caller;
import org.gcube.common.resources.gcore.utils.XPathHelper;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portal.databook.shared.ApplicationProfile;
import org.gcube.portal.databook.shared.Comment;
import org.gcube.portal.databook.shared.Feed;
import org.gcube.portal.databook.shared.FeedType;
import org.gcube.portal.databook.shared.PrivacyLevel;
import org.gcube.portal.databook.shared.ex.FeedIDNotFoundException;
import org.gcube.portal.notifications.thread.PostNotificationsThread;
import org.gcube.portal.social.networking.caches.SocialNetworkingSiteFinder;
import org.gcube.portal.social.networking.liferay.ws.GroupManagerWSBuilder;
import org.gcube.portal.social.networking.liferay.ws.UserManagerWSBuilder;
import org.gcube.portal.social.networking.ws.utils.CassandraConnection;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.QueryBox;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeGroup;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

/*
 * Exception performing whole class analysis ignored.
 */
public class Utils {
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);
    public static final String NO_TEXT_FILE_SHARE = "_N0_73X7_SH4R3_";
    public static final String NEWS_FEED_PORTLET_CLASSNAME = "org.gcube.portlets.user.newsfeed.server.NewsServiceImpl";

    public static Feed shareApplicationUpdate(String postText, String uriParams, String previewTitle, String previewDescription, String httpImageUrl, ApplicationProfile applicationProfile, Caller caller, boolean notifyGroup) {
        String escapedFeedText = org.gcube.social_networking.socialutillibrary.Utils.escapeHtmlAndTransformUrl((String)postText);
        logger.info("Escaped post text is " + escapedFeedText);
        String scope = ScopeProvider.instance.get();
        String appId = caller.getClient().getId();
        List hashtags = org.gcube.social_networking.socialutillibrary.Utils.getHashTags((String)postText);
        if (hashtags != null && !hashtags.isEmpty()) {
            escapedFeedText = org.gcube.social_networking.socialutillibrary.Utils.convertHashtagsAnchorHTML((String)escapedFeedText, (List)hashtags);
        }
        Feed toWrite = Utils.buildFeed((String)escapedFeedText, (String)(uriParams == null ? "" : uriParams), (String)(previewTitle == null ? "" : previewTitle), (String)(previewDescription == null ? "" : previewDescription), (String)(httpImageUrl == null ? "" : httpImageUrl), (ApplicationProfile)applicationProfile, (String)scope);
        boolean res = CassandraConnection.getInstance().getDatabookStore().saveAppFeed(toWrite);
        if (res) {
            logger.info("Feed correctly written by application " + appId);
            if (notifyGroup) {
                logger.debug("Sending notifications for " + appId + " " + scope);
                try {
                    String name = new ScopeBean(scope).name();
                    GroupManager gManager = GroupManagerWSBuilder.getInstance().getGroupManager();
                    long groupId = gManager.getGroupId(name);
                    String groupName = gManager.getGroup(groupId).getGroupName();
                    logger.debug("Company id and name " + groupId + " " + groupName);
                    SocialNetworkingSite site = SocialNetworkingSiteFinder.getSocialNetworkingSiteFromScope((String)ScopeProvider.instance.get());
                    SocialNetworkingUser user = new SocialNetworkingUser(appId, "", applicationProfile.getName(), applicationProfile.getImageUrl());
                    ApplicationNotificationsManager nm = new ApplicationNotificationsManager(UserManagerWSBuilder.getInstance().getUserManager(), site, scope, user, "org.gcube.portlets.user.newsfeed.server.NewsServiceImpl");
                    new Thread((Runnable)new PostNotificationsThread(UserManagerWSBuilder.getInstance().getUserManager(), toWrite.getKey(), toWrite.getDescription(), "" + groupId, (NotificationsManager)nm, new ArrayList())).start();
                }
                catch (Exception e) {
                    logger.debug("Feed succesfully created but unable to send notifications.");
                }
            }
            return toWrite;
        }
        return null;
    }

    private static Feed buildFeed(String description, String uriParams, String previewTitle, String previewDescription, String previewThumbnailUrl, ApplicationProfile applicationProfile, String scopeApp) {
        String uri = applicationProfile.getUrl();
        if (uriParams != null && uriParams.compareTo("") != 0) {
            uri = String.valueOf(uri) + "?" + uriParams;
        }
        Feed toReturn = new Feed(UUID.randomUUID().toString(), FeedType.PUBLISH, applicationProfile.getKey(), new Date(), scopeApp, uri, previewThumbnailUrl, description, PrivacyLevel.SINGLE_VRE, applicationProfile.getName(), "no-email", applicationProfile.getImageUrl(), previewTitle, previewDescription, "", true);
        return toReturn;
    }

    public static ApplicationProfile getProfileFromInfrastrucure(String idApp, String scopeApp) {
        ScopeBean scope = new ScopeBean(scopeApp);
        logger.debug("Trying to fetch applicationProfile profile from the infrastructure for " + idApp + " scope: " + scope);
        String rootInfrastructure = scopeApp.split("/")[1];
        ScopeProvider.instance.set("/" + rootInfrastructure);
        try {
            ApplicationProfile toReturn = new ApplicationProfile();
            QueryBox q = new QueryBox("for $profile in collection('/db/Profiles/GenericResource')//Resource where $profile/Profile/SecondaryType/string() eq 'ApplicationProfile' and  $profile/Profile/Body/AppId/string()  eq '" + idApp + "'" + "return $profile");
            DiscoveryClient client = ICFactory.client();
            List appProfile = client.submit((Query)q);
            if (appProfile == null || appProfile.size() == 0) {
                throw new Exception("Your applicationProfile is not registered in the infrastructure");
            }
            String elem = (String)appProfile.get(0);
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Element node = docBuilder.parse(new InputSource(new StringReader(elem))).getDocumentElement();
            XPathHelper helper = new XPathHelper((Node)node);
            List currValue = null;
            currValue = helper.evaluate("/Resource/Profile/Name/text()");
            if (currValue == null || currValue.size() <= 0) {
                throw new ApplicationProfileNotFoundException("Your applicationProfile NAME was not found in the profile");
            }
            toReturn.setName((String)currValue.get(0));
            currValue = helper.evaluate("/Resource/Profile/Description/text()");
            if (currValue != null && currValue.size() > 0) {
                toReturn.setDescription((String)currValue.get(0));
            } else {
                logger.warn("No Description exists for " + toReturn.getName());
            }
            currValue = helper.evaluate("/Resource/Profile/Body/AppId/text()");
            if (currValue == null || currValue.size() <= 0) {
                throw new ApplicationProfileNotFoundException("Your applicationProfile ID n was not found in the profile, consider adding <AppId> element in <Body>");
            }
            toReturn.setKey((String)currValue.get(0));
            currValue = helper.evaluate("/Resource/Profile/Body/ThumbnailURL/text()");
            if (currValue == null || currValue.size() <= 0) {
                throw new Exception("Your applicationProfile Image Url was not found in the profile, consider adding <ThumbnailURL> element in <Body>");
            }
            toReturn.setImageUrl((String)currValue.get(0));
            currValue = helper.evaluate("/Resource/Profile/Body/EndPoint/Scope/text()");
            if (currValue != null && currValue.size() > 0) {
                List scopes = currValue;
                boolean foundUrl = false;
                int i = 0;
                while (i < scopes.size()) {
                    if (((String)currValue.get(i)).trim().compareTo(scope.toString()) == 0) {
                        toReturn.setUrl((String)helper.evaluate("/Resource/Profile/Body/EndPoint/URL/text()").get(i));
                        toReturn.setScope(scope.toString());
                        foundUrl = true;
                        break;
                    }
                    ++i;
                }
                if (!foundUrl) {
                    throw new ApplicationProfileNotFoundException("Your applicationProfile URL was not found in the profile for Scope: " + scope.toString());
                }
            } else {
                throw new ApplicationProfileNotFoundException("Your applicationProfile EndPoint was not found in the profile, consider adding <EndPoint><Scope> element in <Body>");
            }
            logger.debug("Returning " + toReturn);
            ApplicationProfile applicationProfile = toReturn;
            return applicationProfile;
        }
        catch (Exception e) {
            logger.error("Error while trying to fetch applicationProfile profile from the infrastructure", (Throwable)e);
        }
        finally {
            ScopeProvider.instance.set(scopeApp);
        }
        return null;
    }

    public static Feed shareUserUpdate(String userId, String postText, String vreId, String previewTitle, String previewDescription, String previewHost, String previewUrl, String urlThumbnail, boolean notifyGroup) {
        String url;
        GCubeUser user;
        String escapedFeedText = org.gcube.social_networking.socialutillibrary.Utils.escapeHtmlAndTransformUrl((String)postText);
        List hashtags = org.gcube.social_networking.socialutillibrary.Utils.getHashTags((String)postText);
        if (hashtags != null && !hashtags.isEmpty()) {
            escapedFeedText = org.gcube.social_networking.socialutillibrary.Utils.convertHashtagsAnchorHTML((String)escapedFeedText, (List)hashtags);
        }
        UserManager uManager = UserManagerWSBuilder.getInstance().getUserManager();
        try {
            user = uManager.getUserByUsername(userId);
        }
        catch (Exception e) {
            logger.error("Unable to get user informations, feed write fails.", (Throwable)e);
            return null;
        }
        String email = user.getEmail();
        String fullName = String.valueOf(user.getFirstName()) + " " + user.getLastName();
        String thumbnailURL = user.getUserAvatarURL();
        String linkTitle = previewTitle == null ? "" : previewTitle;
        String linkDesc = previewDescription == null ? "" : previewDescription;
        String host = previewHost == null ? "" : previewHost;
        String string = url = previewUrl == null ? "" : previewUrl;
        if (urlThumbnail == null) {
            urlThumbnail = "null";
        }
        String textToPost = "";
        textToPost = escapedFeedText.trim().compareTo("_N0_73X7_SH4R3_") == 0 ? org.gcube.social_networking.socialutillibrary.Utils.convertFileNameAnchorHTML((String)url) : escapedFeedText;
        Feed toShare = new Feed(UUID.randomUUID().toString(), FeedType.PUBLISH, userId, new Date(), vreId, url, urlThumbnail, textToPost, PrivacyLevel.SINGLE_VRE, fullName, email, thumbnailURL, linkTitle, linkDesc, host);
        logger.info("Attempting to save Feed with text: " + textToPost + " Level = " + PrivacyLevel.SINGLE_VRE + " Timeline = " + vreId);
        boolean result = CassandraConnection.getInstance().getDatabookStore().saveUserFeed(toShare);
        if (vreId != null && vreId.compareTo("") != 0 && result) {
            logger.trace("Attempting to write onto " + vreId);
            try {
                try {
                    logger.info("Sleeping waiting for cassandra's update");
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    logger.error(e.toString());
                }
                CassandraConnection.getInstance().getDatabookStore().saveFeedToVRETimeline(toShare.getKey(), vreId);
                if (hashtags != null && !hashtags.isEmpty()) {
                    CassandraConnection.getInstance().getDatabookStore().saveHashTags(toShare.getKey(), vreId, hashtags);
                }
            }
            catch (FeedIDNotFoundException e) {
                logger.error("Error writing onto VRES Time Line" + vreId);
            }
            logger.trace("Success writing onto " + vreId);
        }
        if (!result) {
            return null;
        }
        if (vreId != null && vreId.compareTo("") != 0 && notifyGroup) {
            try {
                SocialNetworkingSite site = SocialNetworkingSiteFinder.getSocialNetworkingSiteFromScope((String)ScopeProvider.instance.get());
                GroupManager gManager = GroupManagerWSBuilder.getInstance().getGroupManager();
                GCubeUser userInfo = uManager.getUserByUsername(userId);
                SocialNetworkingUser socialUser = new SocialNetworkingUser(userId, userInfo.getEmail(), userInfo.getFullname(), userInfo.getUserAvatarURL());
                String name = new ScopeBean(vreId).name();
                long groupId = gManager.getGroupId(name);
                String groupName = gManager.getGroup(groupId).getGroupName();
                logger.debug("Company id and name " + groupId + " " + groupName);
                ApplicationNotificationsManager nm = new ApplicationNotificationsManager(UserManagerWSBuilder.getInstance().getUserManager(), site, vreId, socialUser, "org.gcube.portlets.user.newsfeed.server.NewsServiceImpl");
                new Thread((Runnable)new PostNotificationsThread(UserManagerWSBuilder.getInstance().getUserManager(), toShare.getKey(), toShare.getDescription(), "" + groupId, (NotificationsManager)nm, hashtags)).start();
                logger.debug("Start sending notifications for feed written by " + userId);
            }
            catch (Exception e) {
                logger.error("Unable to notify users", (Throwable)e);
            }
        }
        return toShare;
    }

    public static void filterFeedsPerContextById(List<String> feedsIds, String context) throws Exception {
        DatabookStore datastore = CassandraConnection.getInstance().getDatabookStore();
        ArrayList<Feed> feeds = new ArrayList<Feed>();
        for (String feedId : feedsIds) {
            try {
                feeds.add(datastore.readFeed(feedId));
            }
            catch (Exception e) {
                logger.error("Unable to read feed with id " + feedId, (Throwable)e);
            }
        }
        Utils.filterFeedsPerContext(feeds, (String)context);
        feedsIds.clear();
        for (Feed feed : feeds) {
            feedsIds.add(feed.getKey());
        }
    }

    public static void filterFeedsPerContext(List<Feed> feeds, String context) throws Exception {
        GroupManager gm = GroupManagerWSBuilder.getInstance().getGroupManager();
        GCubeGroup group = gm.getGroup(gm.getGroupIdFromInfrastructureScope(context));
        ArrayList<String> contexts = new ArrayList<String>();
        if (gm.isRootVO(group.getGroupId()).booleanValue()) {
            return;
        }
        if (gm.isVO(group.getGroupId()).booleanValue()) {
            List vres = group.getChildren();
            for (GCubeGroup gCubeGroup : vres) {
                contexts.add(gm.getInfrastructureScope(gCubeGroup.getGroupId()));
            }
        } else {
            contexts.add(gm.getInfrastructureScope(group.getGroupId()));
        }
        Iterator<Feed> iterator = feeds.iterator();
        while (iterator.hasNext()) {
            Feed feed = iterator.next();
            if (contexts.contains(feed.getVreid())) continue;
            iterator.remove();
        }
    }

    public static void filterCommentsPerContext(List<Comment> comments, String context) throws Exception {
        GroupManager gm = GroupManagerWSBuilder.getInstance().getGroupManager();
        GCubeGroup group = gm.getGroup(gm.getGroupIdFromInfrastructureScope(context));
        ArrayList<String> contexts = new ArrayList<String>();
        if (gm.isRootVO(group.getGroupId()).booleanValue()) {
            return;
        }
        if (gm.isVO(group.getGroupId()).booleanValue()) {
            List vres = group.getChildren();
            for (GCubeGroup gCubeGroup : vres) {
                contexts.add(gm.getInfrastructureScope(gCubeGroup.getGroupId()));
            }
        } else {
            contexts.add(gm.getInfrastructureScope(group.getGroupId()));
        }
        DatabookStore datastore = CassandraConnection.getInstance().getDatabookStore();
        Iterator<Comment> iterator = comments.iterator();
        while (iterator.hasNext()) {
            try {
                Comment comment = iterator.next();
                Feed parent = datastore.readFeed(comment.getFeedid());
                if (contexts.contains(parent.getVreid())) continue;
                iterator.remove();
            }
            catch (Exception e) {
                logger.warn("Failed to analyze this comment", (Throwable)e);
                iterator.remove();
            }
        }
    }
}

