/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social.networking.ws.methods.v1;

import java.util.ArrayList;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.provider.UserInfo;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portal.databook.shared.ApplicationProfile;
import org.gcube.portal.social.networking.ws.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/tokens")
public class Tokens {
    private static final String DEFAULT_ROLE = "OrganizationMember";
    private static final Logger logger = LoggerFactory.getLogger(Tokens.class);

    @POST
    @Path(value="generateApplicationToken/")
    @Produces(value={"text/plain"})
    public Response generateApplicationToken(@FormParam(value="appid") String appId) {
        logger.info("Incoming request for app token generation. Appid id is " + appId);
        String userScope = ScopeProvider.instance.get();
        ApplicationProfile appProfile = Utils.getProfileFromInfrastrucure((String)appId, (String)userScope);
        if (appProfile == null) {
            logger.error("There is no application profile for this application id and scope!");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"There is no application profile for this app id/scope.").build();
        }
        logger.info("Generating token for the application with id " + appId);
        ArrayList<String> roles = new ArrayList<String>();
        roles.add(DEFAULT_ROLE);
        String appToken = null;
        try {
            appToken = Constants.authorizationService().generateUserToken(new UserInfo(appId, new ArrayList()), userScope);
        }
        catch (Exception e) {
            logger.error("Unable to generate token for app " + appId + " and scope " + userScope);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Token generation failed.").build();
        }
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)appToken).build();
    }
}

