/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social.networking.ws.inputs;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.constraints.NotNull;
import org.gcube.portal.databook.shared.JobStatusType;
import org.gcube.portal.databook.shared.RunningJob;
import org.gcube.portal.social.networking.ws.providers.JobStatusTypeDeserializer;

@JsonIgnoreProperties(ignoreUnknown=true)
public class JobNotificationBean {
    @JsonProperty(value="token_recipient")
    @NotNull(message="token recipient cannot be missing")
    private String recipientToken;
    @JsonProperty(value="job_id")
    @NotNull(message="job_id cannot be missing")
    private String jobId;
    @JsonProperty(value="job_name")
    @NotNull(message="job_name cannot be missing")
    private String jobName;
    @JsonProperty(value="status")
    @JsonDeserialize(using=JobStatusTypeDeserializer.class)
    private JobStatusType status;
    @JsonProperty(value="status_message")
    private String statusMessage;

    public JobNotificationBean() {
    }

    public JobNotificationBean(String recipient, String jobId, String jobName, JobStatusType status, String statusMessage) {
        this.recipientToken = recipient;
        this.jobId = jobId;
        this.jobName = jobName;
        this.status = status;
        this.statusMessage = statusMessage;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public String getRecipientToken() {
        return this.recipientToken;
    }

    public void setRecipientToken(String recipientToken) {
        this.recipientToken = recipientToken;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public JobStatusType getStatus() {
        return this.status;
    }

    public void setStatus(JobStatusType status) {
        this.status = status;
    }

    public RunningJob getRunningJob() {
        return new RunningJob(this.jobId, this.jobName, this.status, this.statusMessage);
    }

    public String toString() {
        return "JobNotificationBean [" + (this.recipientToken != null ? "recipientToken=" + this.recipientToken + ", " : "") + (this.jobId != null ? "jobId=" + this.jobId + ", " : "") + (this.jobName != null ? "jobName=" + this.jobName + ", " : "") + (this.status != null ? "status=" + this.status + ", " : "") + (this.statusMessage != null ? "statusMessage=" + this.statusMessage : "") + "]";
    }
}

