/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social.networking.caches;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gcube.applicationsupportlayer.social.shared.SocialNetworkingSite;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portal.social.networking.caches.CacheBean;
import org.gcube.portal.social.networking.liferay.ws.GroupManagerWSBuilder;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.smartgears.ContextProvider;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.model.GCubeGroup;
import org.gcube.vomanagement.usermanagement.model.VirtualGroup;
import org.jboss.netty.util.internal.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SocialNetworkingSiteFinder {
    private static final Logger logger = LoggerFactory.getLogger(SocialNetworkingSiteFinder.class);
    private static final long TTL = 28800000L;
    private static final String EMAIL_SENDER_SITE_CUSTOM_FIELD = "Emailsender";
    private static final String CATEGORY = "Portal";
    private static final String PROD_FALLBACK_GATEWAY = "D4Science.org Gateway";
    private static final String DEV_FALLBACK_GATEWAY = "gCube Dev4 Snapshot Gateway";
    private static Map<String, CacheBean> cache;
    private static SocialNetworkingSiteFinder singleton;

    static {
        singleton = new SocialNetworkingSiteFinder();
    }

    private SocialNetworkingSiteFinder() {
        cache = new ConcurrentHashMap();
    }

    public static SocialNetworkingSiteFinder getInstance() {
        return singleton;
    }

    public static SocialNetworkingSite getSocialNetworkingSiteFromScope(String scope) {
        if (scope == null || scope.isEmpty()) {
            throw new IllegalArgumentException("Scope cannot be null/empty");
        }
        if (cache.containsKey(scope) && !SocialNetworkingSiteFinder.isExpired((CacheBean)((CacheBean)cache.get(scope)))) {
            return (SocialNetworkingSite)((CacheBean)cache.get(scope)).getObject();
        }
        SocialNetworkingSite site = SocialNetworkingSiteFinder.discoverSite((String)scope);
        if (site != null) {
            cache.put(scope, new CacheBean(Long.valueOf(System.currentTimeMillis()), (Object)site));
        }
        return site;
    }

    private static boolean isExpired(CacheBean entry) {
        return System.currentTimeMillis() > entry.getTimestamp() + 28800000L;
    }

    private static SocialNetworkingSite discoverSite(String scope) {
        GCubeGroup matchingGateway;
        GroupManager groupManager;
        block11: {
            try {
                block10: {
                    logger.info("Requested site for scope " + scope);
                    groupManager = GroupManagerWSBuilder.getInstance().getGroupManager();
                    long groupId = groupManager.getGroupIdFromInfrastructureScope(scope);
                    matchingGateway = null;
                    if (groupManager.isVRE(groupId).booleanValue()) {
                        List virtualGroupsOfGroup = groupManager.getVirtualGroups(groupId);
                        if (virtualGroupsOfGroup == null || virtualGroupsOfGroup.isEmpty()) {
                            throw new Exception("It seems that the VRE is not linked to any VirtualGroups");
                        }
                        List gateways = groupManager.getGateways();
                        if (gateways == null || gateways.isEmpty()) {
                            throw new Exception("It seems there is no gateway here!");
                        }
                        logger.info("Retrieved Gateways are " + gateways);
                        for (GCubeGroup gateway : gateways) {
                            List gatewayVirtualGroups = groupManager.getVirtualGroups(gateway.getGroupId());
                            if (gatewayVirtualGroups == null || gatewayVirtualGroups.isEmpty()) continue;
                            for (VirtualGroup gatewayVirtualGroup : gatewayVirtualGroups) {
                                if (!virtualGroupsOfGroup.contains(gatewayVirtualGroup)) continue;
                                logger.info("Matching gateway for scope " + scope + " is " + gateway);
                                matchingGateway = gateway;
                                break block10;
                            }
                        }
                    } else {
                        List gateways = groupManager.getGateways();
                        ApplicationContext ctx = ContextProvider.get();
                        String rootContext = "/" + ctx.container().configuration().infrastructure();
                        String matchingGatewayName = null;
                        matchingGatewayName = SocialNetworkingSiteFinder.isDev((String)rootContext) ? "gCube Dev4 Snapshot Gateway" : "D4Science.org Gateway";
                        for (GCubeGroup gateway : gateways) {
                            if (!gateway.getGroupName().equals(matchingGatewayName)) continue;
                            matchingGateway = gateway;
                            break;
                        }
                    }
                }
                if (matchingGateway != null) break block11;
                logger.warn("There is no gateway for such scope. Returning null");
                return null;
            }
            catch (Exception e) {
                logger.error("Failed to determine the SocialNetworkingSite for scope " + scope, (Throwable)e);
                return null;
            }
        }
        String siteName = matchingGateway.getGroupName();
        String emailSender = (String)((Object)groupManager.readCustomAttr(matchingGateway.getGroupId(), "Emailsender"));
        String siteLandingPagePath = matchingGateway.getFriendlyURL();
        String siteUrl = SocialNetworkingSiteFinder.discoverHostOfServiceEndpoint((String)siteName);
        SocialNetworkingSite site = new SocialNetworkingSite(siteName, emailSender, siteUrl, siteLandingPagePath);
        logger.info("Site is " + site);
        return site;
    }

    private static boolean isDev(String rootContext) {
        return rootContext.equals("/gcube");
    }

    private static String discoverHostOfServiceEndpoint(String gatewayName) {
        String currentScope = ScopeProvider.instance.get();
        ApplicationContext ctx = ContextProvider.get();
        ScopeProvider.instance.set("/" + ctx.container().configuration().infrastructure());
        String host = null;
        try {
            try {
                XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
                query.addCondition("$resource/Profile/Name/text() eq '" + gatewayName + "'");
                query.addCondition("$resource/Profile/Category/text() eq 'Portal'");
                DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
                List toReturn = client.submit((Query)query);
                Iterator iterator = toReturn.iterator();
                if (iterator.hasNext()) {
                    ServiceEndpoint serviceEndpoint = (ServiceEndpoint)iterator.next();
                    host = "https://" + serviceEndpoint.profile().runtime().hostedOn();
                    logger.info("Gateway host is " + host);
                }
            }
            catch (Exception e) {
                logger.error("Error while retrieving host for the gateway " + gatewayName);
                ScopeProvider.instance.set(currentScope);
            }
        }
        finally {
            ScopeProvider.instance.set(currentScope);
        }
        return host;
    }
}

