/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social.networking.ws.providers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.gcube.portal.databook.shared.JobStatusType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobStatusTypeDeserializer
extends JsonDeserializer<JobStatusType> {
    private static final Logger logger = LoggerFactory.getLogger(JobStatusTypeDeserializer.class);

    public JobStatusType deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JobStatusType[] values;
        logger.trace("Status deserializer called");
        ObjectCodec oc = p.getCodec();
        JsonNode node = (JsonNode)oc.readTree(p);
        String status = node.get("status").textValue();
        JobStatusType toReturn = null;
        logger.debug("Status coming from json object is " + status);
        for (JobStatusType jobStatusType : values = JobStatusType.values()) {
            if (!jobStatusType.toString().toLowerCase().contains(status.toLowerCase())) continue;
            toReturn = jobStatusType;
            break;
        }
        logger.debug("JOB STATUS deserialzed as " + toReturn);
        return toReturn;
    }
}

