/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social.networking.ws.inputs;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.gcube.portal.databook.shared.JobStatusType;
import org.gcube.portal.databook.shared.RunningJob;
import org.gcube.portal.social.networking.ws.providers.JobStatusTypeDeserializer;

@JsonIgnoreProperties(ignoreUnknown=true)
public class JobNotificationBean {
    @JsonProperty(value="recipients")
    @NotNull(message="recipients cannot be missing")
    @Size(min=1, message="recipients cannot be empty")
    private List<String> recipients;
    @JsonProperty(value="job_id")
    @NotNull(message="job_id cannot be missing")
    private String jobId;
    @JsonProperty(value="job_name")
    @NotNull(message="job_name cannot be missing")
    private String jobName;
    @JsonProperty(value="status")
    @NotNull(message="status cannot be missing")
    private JobStatusType status;
    @JsonProperty(value="status_message")
    private String statusMessage;

    public JobNotificationBean() {
    }

    public JobNotificationBean(List<String> recipients, String jobId, String jobName, JobStatusType status, String statusMessage) {
        this.recipients = recipients;
        this.jobId = jobId;
        this.jobName = jobName;
        this.status = status;
        this.statusMessage = statusMessage;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public List<String> getRecipients() {
        return this.recipients;
    }

    public void setRecipients(List<String> recipients) {
        this.recipients = recipients;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public JobStatusType getStatus() {
        return this.status;
    }

    @JsonDeserialize(using=JobStatusTypeDeserializer.class)
    public void setStatus(JobStatusType status) {
        this.status = status;
    }

    public RunningJob getRunningJob() {
        return new RunningJob(this.jobId, this.jobName, this.status, this.statusMessage);
    }

    public String toString() {
        return "JobNotificationBean [" + (this.recipients != null ? "recipients=" + this.recipients + ", " : "") + (this.jobId != null ? "jobId=" + this.jobId + ", " : "") + (this.jobName != null ? "jobName=" + this.jobName + ", " : "") + (this.status != null ? "status=" + this.status + ", " : "") + (this.statusMessage != null ? "statusMessage=" + this.statusMessage : "") + "]";
    }
}

