/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social.networking.ws.methods.v2;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.utils.Caller;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portal.social.networking.ws.outputs.ResponseBean;
import org.gcube.portal.social.networking.ws.utils.CassandraConnection;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="2/hashtags")
@Api(tags={"hashtags"}, protocols="https", authorizations={@Authorization(value="gcube-token")})
public class HashTags {
    private static final Logger logger = LoggerFactory.getLogger(HashTags.class);

    @GET
    @Path(value="get-hashtags-and-occurrences/")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve hashtags", notes="Retrieve hashtags in the context bound to the gcube-token", response=ResponseBean.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Hashtags and occurrences retrieved, reported in the 'result' field of the returned object", response=ResponseBean.class), @ApiResponse(code=500, message="The error is reported into the 'message' field of the returned object", response=ResponseBean.class)})
    public Response getHashTagsAndOccurrences() {
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        String context = ScopeProvider.instance.get();
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        logger.info("User " + username + " has requested hashtags of context " + context);
        try {
            DatabookStore datastore = CassandraConnection.getDatabookStore();
            LiferayGroupManager gm = new LiferayGroupManager();
            boolean isVRE = gm.isVRE(gm.getGroupIdFromInfrastructureScope(context));
            if (isVRE) {
                Map map = datastore.getVREHashtagsWithOccurrence(context);
                responseBean.setResult((Object)map);
                responseBean.setSuccess(true);
            } else {
                responseBean.setMessage("Please provide a VRE token");
                responseBean.setResult((Object)false);
            }
        }
        catch (Exception e) {
            logger.error("Failed to retrieve hashtags", (Throwable)e);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }
}

