/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social.networking.ws.methods.v1;

import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.utils.Caller;
import org.gcube.portal.social.networking.ws.utils.CassandraConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/notifications")
public class Notifications {
    private static final Logger logger = LoggerFactory.getLogger(Notifications.class);

    @GET
    @Path(value="getRangeNotificationsByUser/")
    @Produces(value={"application/json", "text/plain"})
    public Response getRangeNotificationsByUser(@QueryParam(value="from") int from, @QueryParam(value="quantity") int quantity) {
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        logger.info("Retrieving " + quantity + " notifications of user = " + username + " from " + from);
        if (from <= 0 || quantity <= 0) {
            logger.error("Missing/wrong request parameters");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Please check the parameter you passed, it seems a bad request").build();
        }
        List notifications = null;
        try {
            notifications = CassandraConnection.getDatabookStore().getRangeNotificationsByUser(username, from, quantity);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve such notifications.", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        logger.info("List of notifications retrieved");
        return Response.status((Response.Status)Response.Status.OK).entity((Object)notifications).build();
    }
}

