/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social.networking.ws.methods.v2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.io.Serializable;
import javax.validation.ValidationException;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.utils.Caller;
import org.gcube.portal.social.networking.ws.outputs.ResponseBean;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="2/users")
@Api(tags={"/2/users"}, description="Endpoint for user resources", protocols="https", authorizations={@Authorization(value="gcube-token")})
public class Users {
    private static final Logger logger = LoggerFactory.getLogger(Users.class);
    private UserManager userManager = new LiferayUserManager();

    @GET
    @Path(value="get-custom-attribute/")
    @Produces(value={"application/json"})
    @ApiOperation(value="Read a user's custom attribute", notes="Read a user's custom attribute. The user is the one owning the token", response=ResponseBean.class, nickname="get-custom-attribute")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful read of the attribute, reported in the 'result' field of the returned object", response=ResponseBean.class), @ApiResponse(code=404, message="Such an attribute doesn't exist", response=ResponseBean.class), @ApiResponse(code=500, message="The error is reported into the 'message' field of the returned object", response=ResponseBean.class)})
    public Response readCustomAttr(@QueryParam(value="attribute") @NotNull(message="attribute name is missing") @ApiParam(name="attribute", required=true, allowMultiple=false, value="The key of the attribute to read") String attributeKey) throws ValidationException {
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            GCubeUser user = this.userManager.getUserByUsername(username);
            String toReturn = (String)((Object)this.userManager.readCustomAttr(user.getUserId(), attributeKey));
            responseBean.setSuccess(true);
            responseBean.setResult((Object)toReturn);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve attribute for user.", (Throwable)e);
            responseBean.setMessage(e.toString());
            responseBean.setSuccess(false);
            status = Response.Status.NOT_FOUND;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @PUT
    @Path(value="update-custom-attribute")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update a user's custom attribute", notes="Update a user's custom attribute. The user is the one owning the token", response=ResponseBean.class, nickname="update-custom-attribute")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful update of the attribute, the new value is reported in the 'result' field of the returned object", response=ResponseBean.class), @ApiResponse(code=400, message="Key or value for the new attribute missing", response=ResponseBean.class), @ApiResponse(code=500, message="The error is reported into the 'message' field of the returned object", response=ResponseBean.class), @ApiResponse(code=304, message="Attribute not modified", response=ResponseBean.class)})
    public Response updateCustomAttr(@NotNull(message="input is missing") @ApiParam(name="input", required=true, allowMultiple=false, value="The object having an attribute key and a value key for the new value") String inputJsonObj) throws ValidationException {
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode actualObj = mapper.readTree(inputJsonObj);
            String attributeKey = actualObj.get("attribute").asText();
            String newValue = actualObj.get("value").asText();
            if (attributeKey == null || attributeKey.isEmpty() || newValue == null) {
                logger.error("Missing/wrong request parameters");
                status = Response.Status.BAD_REQUEST;
                responseBean.setMessage("Missing request parameters.");
                return Response.status((Response.Status)status).entity((Object)responseBean).build();
            }
            GCubeUser user = this.userManager.getUserByUsername(username);
            this.userManager.saveCustomAttr(user.getUserId(), attributeKey, (Serializable)((Object)newValue));
            responseBean.setSuccess(true);
            responseBean.setResult((Object)newValue);
        }
        catch (Exception e) {
            logger.error("Unable to set attribute for user.", (Throwable)e);
            status = Response.Status.NOT_MODIFIED;
            responseBean.setMessage(e.toString());
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Path(value="get-fullname")
    @Produces(value={"application/json"})
    @ApiOperation(value="Read the user's fullname", notes="Read the user's fullname. The user is the one owning the token", response=ResponseBean.class, nickname="get-fullname")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful update of the attribute, the value is reported in the 'result' field of the returned object", response=ResponseBean.class), @ApiResponse(code=500, message="The error is reported into the 'message' field of the returned object", response=ResponseBean.class)})
    public Response getUserUsername() {
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        String fullName = null;
        ResponseBean responseBean = new ResponseBean();
        responseBean.setSuccess(false);
        Response.Status status = Response.Status.OK;
        try {
            GCubeUser user = this.userManager.getUserByUsername(username);
            fullName = user.getFullname();
            logger.info("Found fullname " + fullName + " for user " + username);
            responseBean.setResult((Object)fullName);
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve attribute for user.", (Throwable)e);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Path(value="get-email")
    @Produces(value={"application/json"})
    @ApiOperation(value="Read the user's email address", notes="Read the user's email address. The user is the one owning the token", response=ResponseBean.class, nickname="get-email")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful update of the attribute, the value is reported in the 'result' field of the returned object", response=ResponseBean.class), @ApiResponse(code=500, message="The error is reported into the 'message' field of the returned object", response=ResponseBean.class)})
    public Response getUserEmail() {
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        String email = null;
        ResponseBean responseBean = new ResponseBean();
        responseBean.setSuccess(false);
        Response.Status status = Response.Status.OK;
        try {
            GCubeUser user = this.userManager.getUserByUsername(username);
            email = user.getEmail();
            logger.info("Found email " + email + " for user " + username);
            responseBean.setResult((Object)email);
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve attribute for user.", (Throwable)e);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Path(value="get-profile")
    @Produces(value={"application/json"})
    public Response getUserProfile() {
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        GCubeUser user = null;
        ResponseBean responseBean = new ResponseBean();
        responseBean.setSuccess(false);
        Response.Status status = Response.Status.OK;
        try {
            user = this.userManager.getUserByUsername(username);
            responseBean.setResult((Object)user);
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve attribute for user.", (Throwable)e);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }
}

