/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social.networking.ws.methods.v2;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.List;
import javax.validation.ValidationException;
import javax.validation.constraints.Min;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.utils.Caller;
import org.gcube.portal.social.networking.ws.outputs.ResponseBean;
import org.gcube.portal.social.networking.ws.utils.CassandraConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="2/notifications")
@Api(tags={"/2/notifications"}, description="Endpoint for notifications resources", protocols="https", authorizations={@Authorization(value="gcube-token")})
public class Notifications {
    private static final Logger logger = LoggerFactory.getLogger(Notifications.class);

    @GET
    @Path(value="get-range-notifications/")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve user's notifications", notes="Retrieve notifications of the gcube-token's owner", response=ResponseBean.class, nickname="get-range-notifications")
    @ApiResponses(value={@ApiResponse(code=200, message="Notifications retrieved and reported in the 'result' field of the returned object", response=ResponseBean.class), @ApiResponse(code=500, message="The error is reported into the 'message' field of the returned object", response=ResponseBean.class)})
    public Response getRangeNotifications(@DefaultValue(value="1") @QueryParam(value="from") @Min(value=1L, message="from must be greater or equal to 1") @ApiParam(allowableValues="range[0, infinity]", required=false, allowMultiple=false, value="The base index notification") int from, @DefaultValue(value="10") @QueryParam(value="quantity") @Min(value=0L, message="quantity must be greater or equal to 0") @ApiParam(allowableValues="range[1, infinity]", required=false, allowMultiple=false, value="Retrieve notifications up to this quantity") int quantity) throws ValidationException {
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        logger.debug("Retrieving " + quantity + " notifications of user = " + username + " from " + from);
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        List notifications = null;
        try {
            notifications = CassandraConnection.getDatabookStore().getRangeNotificationsByUser(username, from, quantity);
            responseBean.setResult((Object)notifications);
            responseBean.setMessage("");
            responseBean.setSuccess(true);
            logger.debug("List of notifications retrieved");
        }
        catch (Exception e) {
            logger.error("Unable to retrieve such notifications.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }
}

