/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social.networking.ws.methods.v2;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.ValidationException;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.gcube.applicationsupportlayer.social.ApplicationNotificationsManager;
import org.gcube.applicationsupportlayer.social.NotificationsManager;
import org.gcube.applicationsupportlayer.social.shared.SocialNetworkingSite;
import org.gcube.applicationsupportlayer.social.shared.SocialNetworkingUser;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.utils.Caller;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portal.notifications.bean.GenericItemBean;
import org.gcube.portal.notifications.thread.MessageNotificationsThread;
import org.gcube.portal.social.networking.ws.inputs.MessageInputBean;
import org.gcube.portal.social.networking.ws.inputs.Recipient;
import org.gcube.portal.social.networking.ws.outputs.ResponseBean;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="2/messages")
@Api(tags={"/2/messages"}, description="Endpoint for messages resources", protocols="https", authorizations={@Authorization(value="gcube-token")})
public class Messages {
    private static final Logger logger = LoggerFactory.getLogger(Messages.class);
    private UserManager um = new LiferayUserManager();

    @POST
    @Path(value="write-message/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Write a message to another user", notes="Write a message to another user. The sender is the token's owner by default", response=ResponseBean.class, nickname="write-message")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful write a message, reported in the 'result' field of the returned object", response=ResponseBean.class), @ApiResponse(code=500, message="The error is reported into the 'message' field of the returned object", response=ResponseBean.class)})
    public Response writeMessage(@NotNull(message="Message to send is missing") @Valid @ApiParam(name="input", required=true, allowMultiple=false, value="The message to write") MessageInputBean input, @Context HttpServletRequest httpServletRequest) throws ValidationException {
        logger.debug("Incoming message bean is " + input);
        Caller caller = AuthorizationProvider.instance.get();
        String senderId = caller.getClient().getId();
        String context = ScopeProvider.instance.get();
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.CREATED;
        String sender = input.getSender();
        String body = input.getBody();
        String subject = input.getSubject();
        ArrayList recipientsIds = input.getRecipients();
        if (sender == null || sender.isEmpty()) {
            logger.info("Sender is going to be the token's owner [" + senderId + "]");
        } else {
            logger.info("Sender is going to be " + sender);
            senderId = sender;
        }
        ArrayList<String> recipientsListFiltered = new ArrayList<String>();
        ArrayList<GenericItemBean> recipientsBeans = new ArrayList<GenericItemBean>();
        for (Recipient recipientId : recipientsIds) {
            try {
                String tempId = recipientId.getId().trim();
                if (tempId.isEmpty()) continue;
                GCubeUser userRecipient = this.um.getUserByUsername(tempId);
                GenericItemBean beanUser = new GenericItemBean(userRecipient.getUsername(), userRecipient.getUsername(), userRecipient.getFullname(), userRecipient.getUserAvatarURL());
                recipientsBeans.add(beanUser);
                recipientsListFiltered.add(tempId);
            }
            catch (Exception e) {
                logger.error("Unable to retrieve recipient information for recipient with id " + recipientId, (Throwable)e);
            }
        }
        if (recipientsListFiltered.isEmpty()) {
            logger.error("Missing/wrong request parameters");
            status = Response.Status.BAD_REQUEST;
            responseBean.setMessage("Missing request parameters.");
            return Response.status((Response.Status)status).entity((Object)responseBean).build();
        }
        try {
            logger.debug("Trying to send message with body " + body + " subject " + subject + " to user " + recipientsIds + " from " + senderId);
            GCubeUser senderUser = this.um.getUserByUsername(senderId);
            Workspace workspace = HomeLibrary.getUserWorkspace((String)senderId);
            logger.debug("Sending message to " + recipientsListFiltered);
            String messageId = workspace.getWorkspaceMessageManager().sendMessageToPortalLogins(subject, body, new ArrayList(), recipientsListFiltered);
            logger.debug("Message sent to " + recipientsIds + ". Sending message notification to: " + recipientsIds);
            SocialNetworkingSite site = new SocialNetworkingSite(httpServletRequest);
            SocialNetworkingUser user = new SocialNetworkingUser(senderUser.getUsername(), senderUser.getEmail(), senderUser.getFullname(), senderUser.getUserAvatarURL());
            ApplicationNotificationsManager nm = new ApplicationNotificationsManager(site, context, user);
            new Thread((Runnable)new MessageNotificationsThread(recipientsBeans, messageId, subject, body, (NotificationsManager)nm)).start();
            responseBean.setSuccess(true);
            responseBean.setResult((Object)messageId);
        }
        catch (Exception e) {
            logger.error("Unable to send message.", (Throwable)e);
            status = Response.Status.INTERNAL_SERVER_ERROR;
            responseBean.setMessage(e.getMessage());
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Path(value="get-sent-messages")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve the list of sent messages", notes="Retrieve the list of sent messages. The user is the token's owner by default", response=ResponseBean.class, nickname="get-sent-messages")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful read sent messages, reported in the 'result' field of the returned object", response=ResponseBean.class), @ApiResponse(code=500, message="The error is reported into the 'message' field of the returned object", response=ResponseBean.class)})
    public Response getSentMessages() {
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        logger.info("Request for retrieving sent messages by " + username);
        try {
            Workspace workspace = HomeLibrary.getUserWorkspace((String)username);
            List sentMessages = workspace.getWorkspaceMessageManager().getReceivedMessages();
            responseBean.setSuccess(true);
            logger.debug("Result is " + sentMessages);
            responseBean.setResult((Object)sentMessages);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve sent messages", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Path(value="get-received-messages")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve the list of received messages", notes="Retrieve the list of received messages. The user is the token's owner by default", response=ResponseBean.class, nickname="get-received-messages")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful read received messages, reported in the 'result' field of the returned object", response=ResponseBean.class), @ApiResponse(code=500, message="The error is reported into the 'message' field of the returned object", response=ResponseBean.class)})
    public Response getReceivedMessages() {
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        logger.info("Request for retrieving received messages by " + username);
        try {
            Workspace workspace = HomeLibrary.getUserWorkspace((String)username);
            List getMessages = workspace.getWorkspaceMessageManager().getSentMessages();
            responseBean.setSuccess(true);
            responseBean.setResult((Object)getMessages);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve sent messages", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }
}

