/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social.networking.ws.methods.v1;

import java.util.List;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.utils.Caller;
import org.gcube.portal.social.networking.ws.utils.CassandraConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/likes")
public class Likes {
    private static final Logger logger = LoggerFactory.getLogger(Likes.class);

    @GET
    @Path(value="getAllLikedPostIdsByUser/")
    @Produces(value={"application/json", "text/plain"})
    public Response getAllLikedPostIdsByUser() {
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        logger.info("Retrieving all liked feeds for user with id " + username);
        List retrievedLikedFeeds = null;
        try {
            retrievedLikedFeeds = CassandraConnection.getDatabookStore().getAllLikedFeedIdsByUser(username);
        }
        catch (Exception e) {
            logger.error("Unable to read such ids of liked feeds.", (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        logger.info("Ids of liked feeds by " + username + " retrieved");
        return Response.status((Response.Status)Response.Status.OK).entity((Object)retrievedLikedFeeds).build();
    }

    @GET
    @Path(value="getAllLikedPostsByUser/")
    @Produces(value={"application/json", "text/plain"})
    public Response getAllLikedPostsByUser(@DefaultValue(value="10") @QueryParam(value="limit") int limit) {
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        List retrievedLikedFeeds = null;
        try {
            logger.info("Retrieving " + limit + " liked feeds for user with id " + username);
            retrievedLikedFeeds = CassandraConnection.getDatabookStore().getAllLikedFeedsByUser(username, limit);
        }
        catch (Exception e) {
            logger.error("Unable to read such liked feeds.", (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        logger.info("Liked feeds by " + username + " retrieved");
        return Response.status((Response.Status)Response.Status.OK).entity((Object)retrievedLikedFeeds).build();
    }
}

