/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social.networking.ws.filters;

import java.io.IOException;
import java.util.List;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.utils.Caller;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portal.social.networking.ws.outputs.ResponseBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Provider
public class RequestsAuthFilter
implements ContainerRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(RequestsAuthFilter.class);
    public static final String AUTH_TOKEN = "gcube-token";
    private static final String MISSING_OR_WRONG_TOKEN = "Invalid or missing gcube-token";
    @Context
    UriInfo info;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        MultivaluedMap queryParameters;
        logger.info("Intercepted request, checking if it contains authorization token");
        logger.info("Requested method is " + this.info.getAbsolutePath());
        String pathRequest = this.info.getAbsolutePath().toString();
        if (pathRequest.endsWith("swagger.json") || pathRequest.endsWith("swagger.yaml") || pathRequest.endsWith("/rest/") || pathRequest.endsWith("/rest")) {
            logger.debug("No authorization is requested in this case, returning");
            return;
        }
        String tokenInHeader = null;
        String tokenAsQueryParameter = null;
        MultivaluedMap headers = requestContext.getHeaders();
        if (headers != null && headers.containsKey((Object)"gcube-token")) {
            tokenInHeader = (String)((List)headers.get((Object)"gcube-token")).get(0);
        }
        if ((queryParameters = requestContext.getUriInfo().getQueryParameters()) != null && queryParameters.containsKey((Object)"gcube-token")) {
            tokenAsQueryParameter = (String)((List)queryParameters.get((Object)"gcube-token")).get(0);
        }
        if (tokenAsQueryParameter == null && tokenInHeader == null) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).type("application/json").entity((Object)new ResponseBean(false, "Invalid or missing gcube-token", null)).build());
            return;
        }
        AuthorizationEntry ae = null;
        if (tokenInHeader != null) {
            logger.info("Token in " + tokenInHeader.substring(0, 5) + "********************");
            ae = RequestsAuthFilter.validateToken((String)tokenInHeader);
        } else if (tokenAsQueryParameter != null) {
            logger.info("Token is " + tokenAsQueryParameter.substring(0, 5) + "********************");
            ae = RequestsAuthFilter.validateToken((String)tokenAsQueryParameter);
        }
        if (ae != null) {
            logger.debug("Setting scope " + ae.getContext());
            AuthorizationProvider.instance.set(new Caller(ae.getClientInfo(), ae.getQualifier()));
            ScopeProvider.instance.set(ae.getContext());
            logger.info("Authorization entry set in thread local");
            return;
        }
        requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).type("application/json").entity((Object)new ResponseBean(false, "Invalid or missing gcube-token", null)).build());
    }

    private static AuthorizationEntry validateToken(String token) {
        AuthorizationEntry res = null;
        try {
            ScopeProvider.instance.set("/" + PortalContext.getConfiguration().getInfrastructureName());
            logger.debug("Validating token " + token);
            res = Constants.authorizationService().get(token);
            logger.debug("Token seems valid for scope " + res.getContext() + " and user " + res.getClientInfo().getId());
        }
        catch (Exception e) {
            logger.error("The token is not valid. This request will be rejected!!! (" + token + ")");
        }
        finally {
            ScopeProvider.instance.reset();
        }
        return res;
    }
}

