package org.gcube.portal.databook.server;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.MalformedParameterizedTypeException;
import java.util.List;
import java.util.Properties;

import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.ISException;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISClient.ISMalformedQueryException;
import org.gcube.common.core.informationsystem.client.ISClient.ISUnsupportedQueryException;
import org.gcube.common.core.informationsystem.client.queries.GCUBERuntimeResourceQuery;
import org.gcube.common.core.resources.GCUBERuntimeResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScope.MalformedScopeExpressionException;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.portal.databook.shared.ex.TooManyRunningClustersException;
/**
 * @author Massimiliano Assante ISTI-CNR
 * 
 * @version 0.1 Dec 2012
 *
 */
@SuppressWarnings("serial")
public class RunningCluster implements Serializable {
	/**
	 * logger
	 */
	static GCUBEClientLog _log = new GCUBEClientLog(RunningCluster.class);
	/**
	 * properties to read
	 */
	private static final String HOST_PROPERTY = "host";	
	private static final String HOST_PORT_PROPERTY = "port";
	private static final String CLUSTER_NAME_PROPERTY = "cluster";	
	private static final String KEY_SPACE_NAME_PROPERTY = "keyspace";
	/**
	 * other constants
	 */
	private final static String RUNTIME_RESOURCE_NAME = "SocialPortalDataStore";
	private final static String PLATFORM_NAME = "Cassandra";

	private static final String DEFAULT_CONFIGURATION = "/org/gcube/portal/databook/server/resources/databook.properties";

	private static RunningCluster singleton;
	/**
	 * Host
	 */
	private String host;
	/**
	 * Cluster Name 
	 */
	private String clusterName;
	/**
	 * Keyspace Name
	 */
	private String keyspaceName;
	/**
	 * 
	 * @return an instance of the RunningCluster
	 */
	public static synchronized RunningCluster getInstance() {
		if (singleton == null) {
			singleton = new RunningCluster();
		}
		return singleton;
	}	
	/**
	 * private constructor
	 */
	private RunningCluster() {
		try {
			List<GCUBERuntimeResource> resources = getConfigurationFromIS();
			if (resources.size() > 1) {
				_log.error("Too many Runtime Resource having name " + RUNTIME_RESOURCE_NAME +" in this scope ");
				throw new TooManyRunningClustersException("There exist more than 1 Runtime Resource in this scope having name " 
				+ RUNTIME_RESOURCE_NAME + " and Platform " + PLATFORM_NAME + ". Only one allowed per infrasrtucture.");
			}
			else if (resources.size() == 0){
				_log.error("There is no Runtime Resource having name " + RUNTIME_RESOURCE_NAME +" and Platform " + PLATFORM_NAME + " in this scope. Using default configuration properties: " + DEFAULT_CONFIGURATION);
				 loadDefaultConfiguration();
			}
			else {
				for (GCUBERuntimeResource res : resources) {
					host = res.getAccessPoints().get(0).getEndpoint();
					clusterName = res.getAccessPoints().get(0).getDescription();
					keyspaceName = res.getAccessPoints().get(0).getEntryname();
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	/**
	 * 
	 * @return the
	 * @throws Exception
	 */
	private List<GCUBERuntimeResource> getConfigurationFromIS() throws Exception  {
		ISClient client = GHNContext.getImplementation(ISClient.class);
		GHNContext ctx = GHNContext.getContext();
		String scope = "/" + (String) ctx.getProperty(GHNContext.INFRASTRUCTURE_NAME, true);
		GCUBERuntimeResourceQuery query = client.getQuery(GCUBERuntimeResourceQuery.class);
		query.addAtomicConditions(new AtomicCondition("/Profile/Name", RUNTIME_RESOURCE_NAME));
		query.addAtomicConditions(new AtomicCondition("/Profile/Platform/Name", PLATFORM_NAME));
		List<GCUBERuntimeResource> toReturn;
		return client.execute(query, GCUBEScope.getScope(scope));
	}	
	/**
	 * 
	 */
	private void loadDefaultConfiguration() {
		Properties props = new Properties();
		try {
			props.load(CassandraClusterConnection.class.getResourceAsStream(DEFAULT_CONFIGURATION));
			host = props.getProperty(HOST_PROPERTY) + ":" + props.getProperty(HOST_PORT_PROPERTY);
			clusterName = props.getProperty(CLUSTER_NAME_PROPERTY);
			keyspaceName = props.getProperty(KEY_SPACE_NAME_PROPERTY);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}


	public String getHost() {
		return host;
	}

	public void setHost(String host) {
		this.host = host;
	}

	public String getClusterName() {
		return clusterName;
	}

	public void setClusterName(String clusterName) {
		this.clusterName = clusterName;
	}

	public String getKeyspaceName() {
		return keyspaceName;
	}

	public void setKeyspaceName(String keyspaceName) {
		this.keyspaceName = keyspaceName;
	}

	@Override
	public String toString() {
		return "RunningCluster [host=" + host + ", clusterName=" + clusterName
				+ ", keyspaceName=" + keyspaceName + "]";
	}
}
