package org.gcube.portal.removeaccount.thread;

import static org.gcube.resources.discovery.icclient.ICFactory.clientFor;
import static org.gcube.resources.discovery.icclient.ICFactory.queryFor;

import java.util.List;
import java.util.Properties;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;

import org.gcube.common.encryption.encrypter.StringEncrypter;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.ServiceEndpoint.AccessPoint;
import org.gcube.common.resources.gcore.ServiceEndpoint.Property;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

/**
 * 
 * @author Massimiliano Assante ISTI-CNR
 *
 */
public class RemovedUserFromLDAPThread implements Runnable {
	private static Log _log = LogFactoryUtil.getLog(RemovedUserFromLDAPThread.class);
	private  static final String LDAP_SERVER_NAME = "LDAPServer";
	private  static final String LDAP_SERVER_FILTER_NAME = "filter";
	private  static final String LDAP_SERVER_PRINCPAL_NAME = "ldapPrincipal";
	private static final String USER_CONTEXT = ",ou=People,o=D4Science,ou=Organizations,dc=d4science,dc=org";

	private String portalName; 
	private String ldapUrl;
	private String principal;
	private String ldapPassword;

	private String username2Delete;

	public RemovedUserFromLDAPThread(String username2Delete) {
		this.username2Delete = username2Delete;
	}


	@SuppressWarnings("deprecation")
	@Override
	public void run() {
		portalName = PortalContext.getPortalInstanceName();

		PortalContext context = PortalContext.getConfiguration();	
		String scope = "/" + context.getInfrastructureName();
		ScopeProvider.instance.set(scope);

		SimpleQuery query = queryFor(ServiceEndpoint.class);
		query.addCondition("$resource/Profile/Category/text() eq 'Portal'");
		query.addCondition("$resource/Profile/Name/text() eq '" + portalName + "'");

		DiscoveryClient<ServiceEndpoint> client = clientFor(ServiceEndpoint.class);

		List<ServiceEndpoint> list = client.submit(query);
		if (list == null || list.isEmpty()) {
			_log.error("Could not find any Service endpoint registred in the infrastructure for this portal: " + portalName);
		}
		else  if (list.size() > 1) {
			_log.warn("Found more than one Service endpoint registred in the infrastructure for this portal: " + portalName);
		}
		else {
			for (ServiceEndpoint res : list) {
				Group<AccessPoint> apGroup =  res.profile().accessPoints();
				AccessPoint[] accessPoints = (AccessPoint[]) apGroup.toArray(new AccessPoint[apGroup.size()]);
				for (int i = 0; i < accessPoints.length; i++) {
					if (accessPoints[i].name().compareTo(LDAP_SERVER_NAME) == 0) {
						_log.info("Found credentials for " + LDAP_SERVER_NAME);
						AccessPoint found = accessPoints[i];
						ldapUrl = found.address();
						String encrPassword = found.password();						
						try {
							ldapPassword = StringEncrypter.getEncrypter().decrypt( encrPassword);
						} catch (Exception e) {
							_log.error("Something went wrong while decrypting password for " + LDAP_SERVER_NAME);
							e.printStackTrace();
						}
						Group<Property> propGroup =  found.properties();
						Property[] props = (Property[]) propGroup.toArray(new Property[propGroup.size()]);
						for (int j = 0; j < props.length; j++) {
							if (props[j].name().compareTo(LDAP_SERVER_PRINCPAL_NAME) == 0) {
								_log.info("\tFound properties of " + LDAP_SERVER_PRINCPAL_NAME);
								String encrValue = props[j].value();						
								try {
									principal = StringEncrypter.getEncrypter().decrypt(encrValue);
								} catch (Exception e) {
									_log.error("Something went wrong while decrypting value for " + LDAP_SERVER_PRINCPAL_NAME);
									e.printStackTrace();
								}
							}
						}

					}
				}
			}
			_log.debug("Got LDAP connection info from IS Resource ...");
			/***************                         */
			_log.debug("Initializing LDAP connection ...");

			Properties env = new Properties();
			env.put(Context.INITIAL_CONTEXT_FACTORY,"com.sun.jndi.ldap.LdapCtxFactory");
			env.put(Context.PROVIDER_URL, ldapUrl);
			env.put(Context.SECURITY_PRINCIPAL, principal);
			env.put(Context.SECURITY_CREDENTIALS, ldapPassword);

			try {
				Context ctx = new InitialContext(env);
				String userCtx2Delete = getSubContext(username2Delete);
				// Remove the binding
				_log.debug("***** trying delete userCtx=" + userCtx2Delete);
				ctx.unbind(userCtx2Delete);
				// Check that it is gone
				Object obj = null;
				try {
					obj = ctx.lookup(userCtx2Delete);
				} catch (NameNotFoundException ne) {
					_log.info("unbind successful for "+userCtx2Delete);
					return;
				}
				_log.error("unbind failed; object still there: " + obj);
				// Close the context when we're done
				ctx.close();
			} catch (NamingException e) {
				_log.error("Something went Wrong during LDAP remove user");
				e.printStackTrace();
			} catch (Exception es) {
				_log.error("Something went Wrong during LDAP remove user in retrieving Liferay Organization");
				es.printStackTrace();
			}	
		}
	}

	/**
	 * 
	 * @param username
	 * @return the single user subContext
	 */
	private String getSubContext(String username) {
		return "uid="+username+USER_CONTEXT;
	}

}
