/*
 * Decompiled with CFR 0.152.
 */
package jodd.util.idgen;

import jodd.util.Base64;
import jodd.util.MathUtil;

public class Uuid24Generator {
    private static final char[] chars64 = Base64.CHARS;

    public static String generateUUID() {
        return new Uuid24Generator().generate();
    }

    public String generate() {
        long id1 = System.currentTimeMillis() & 0xFFFFFFFFL;
        long id2 = System.identityHashCode(this);
        long id3 = MathUtil.randomLong(Integer.MIN_VALUE, 0x80000000L) & 0xFFFFFFFFL;
        id1 <<= 16;
        return Uuid24Generator.unisgnedValueOf(id1 += (id2 & 0xFFFF0000L) >> 16) + Uuid24Generator.unisgnedValueOf(id3 += (id2 & 0xFFFFL) << 32);
    }

    private static String unisgnedValueOf(long l) {
        char[] buf = new char[64];
        int charNdx = 64;
        int radix = 64;
        long mask = radix - 1;
        do {
            buf[--charNdx] = chars64[(int)(l & mask)];
        } while ((l >>>= 6) != 0L);
        return new String(buf, charNdx, 64 - charNdx);
    }
}

