/*
 * Decompiled with CFR 0.152.
 */
package jodd.util.idgen;

public class SimpleLongIdGenerator {
    protected volatile long value;
    protected long initialValue;
    protected long maxValue;
    protected boolean cycle;

    public SimpleLongIdGenerator() {
        this(1L, Long.MAX_VALUE, true);
    }

    public SimpleLongIdGenerator(long initialValue) {
        this(initialValue, Long.MAX_VALUE, true);
    }

    public SimpleLongIdGenerator(long initialValue, long maxValue) {
        this(initialValue, maxValue, true);
    }

    public SimpleLongIdGenerator(long initialValue, long maxValue, boolean cycle) {
        if (initialValue < 0L) {
            throw new IllegalArgumentException("Initial value '" + initialValue + "' must be a positive number.");
        }
        if (maxValue <= initialValue) {
            throw new IllegalArgumentException("Max value '" + maxValue + "' is less or equals to initial value '" + initialValue + "'.");
        }
        this.initialValue = this.value = initialValue;
        this.maxValue = maxValue;
        this.cycle = cycle;
    }

    public synchronized long next() {
        long id = this.value++;
        if (this.value > this.maxValue || this.value < 0L) {
            if (!this.cycle) {
                throw new IllegalStateException("Max value already reached.");
            }
            this.value = this.initialValue;
        }
        return id;
    }
}

