/*
 * Decompiled with CFR 0.152.
 */
package jodd.util.collection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class BooleanArrayList
implements Serializable {
    private boolean[] array;
    private int size;
    public static int initialCapacity = 10;

    public BooleanArrayList() {
        this(initialCapacity);
    }

    public BooleanArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Capacity can't be negative: " + initialCapacity);
        }
        this.array = new boolean[initialCapacity];
        this.size = 0;
    }

    public BooleanArrayList(boolean[] data) {
        this.array = new boolean[(int)((double)data.length * 1.1) + 1];
        this.size = data.length;
        System.arraycopy(data, 0, this.array, 0, this.size);
    }

    public boolean[] toArray() {
        boolean[] result = new boolean[this.size];
        System.arraycopy(this.array, 0, result, 0, this.size);
        return result;
    }

    public boolean get(int index) {
        this.checkRange(index);
        return this.array[index];
    }

    public int size() {
        return this.size;
    }

    public boolean remove(int index) {
        this.checkRange(index);
        boolean oldval = this.array[index];
        int numtomove = this.size - index - 1;
        if (numtomove > 0) {
            System.arraycopy(this.array, index + 1, this.array, index, numtomove);
        }
        --this.size;
        return oldval;
    }

    public void removeRange(int fromIndex, int toIndex) {
        this.checkRange(fromIndex);
        this.checkRange(toIndex);
        if (fromIndex >= toIndex) {
            return;
        }
        int numtomove = this.size - toIndex;
        if (numtomove > 0) {
            System.arraycopy(this.array, toIndex, this.array, fromIndex, numtomove);
        }
        this.size -= toIndex - fromIndex;
    }

    public boolean set(int index, boolean element) {
        this.checkRange(index);
        boolean oldval = this.array[index];
        this.array[index] = element;
        return oldval;
    }

    public void add(boolean element) {
        this.ensureCapacity(this.size + 1);
        this.array[this.size++] = element;
    }

    public void add(int index, boolean element) {
        this.checkRangeIncludingEndpoint(index);
        this.ensureCapacity(this.size + 1);
        int numtomove = this.size - index;
        System.arraycopy(this.array, index, this.array, index + 1, numtomove);
        this.array[index] = element;
        ++this.size;
    }

    public void addAll(boolean[] data) {
        int dataLen = data.length;
        if (dataLen == 0) {
            return;
        }
        int newcap = this.size + (int)((double)dataLen * 1.1) + 1;
        this.ensureCapacity(newcap);
        System.arraycopy(data, 0, this.array, this.size, dataLen);
        this.size += dataLen;
    }

    public void addAll(int index, boolean[] data) {
        int dataLen = data.length;
        if (dataLen == 0) {
            return;
        }
        int newcap = this.size + (int)((double)dataLen * 1.1) + 1;
        this.ensureCapacity(newcap);
        System.arraycopy(this.array, index, this.array, index + dataLen, this.size - index);
        System.arraycopy(data, 0, this.array, index, dataLen);
        this.size += dataLen;
    }

    public void clear() {
        this.size = 0;
    }

    public boolean contains(boolean data) {
        for (int i = 0; i < this.size; ++i) {
            if (this.array[i] != data) continue;
            return true;
        }
        return false;
    }

    public int indexOf(boolean data) {
        for (int i = 0; i < this.size; ++i) {
            if (this.array[i] != data) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(boolean data) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.array[i] != data) continue;
            return i;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void ensureCapacity(int mincap) {
        if (mincap > this.array.length) {
            int newcap = (this.array.length * 3 >> 1) + 1;
            boolean[] olddata = this.array;
            this.array = new boolean[newcap < mincap ? mincap : newcap];
            System.arraycopy(olddata, 0, this.array, 0, this.size);
        }
    }

    public void trimToSize() {
        if (this.size < this.array.length) {
            boolean[] olddata = this.array;
            this.array = new boolean[this.size];
            System.arraycopy(olddata, 0, this.array, 0, this.size);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.array.length);
        for (int i = 0; i < this.size; ++i) {
            out.writeBoolean(this.array[i]);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.array = new boolean[in.readInt()];
        for (int i = 0; i < this.size; ++i) {
            this.array[i] = in.readBoolean();
        }
    }

    private void checkRange(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index should be at least 0 and less than " + this.size + ", found " + index);
        }
    }

    private void checkRangeIncludingEndpoint(int index) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index should be at least 0 and at most " + this.size + ", found " + index);
        }
    }
}

