/*
 * Decompiled with CFR 0.152.
 */
package jodd.typeconverter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import jodd.datetime.JDateTime;
import jodd.mutable.MutableByte;
import jodd.mutable.MutableDouble;
import jodd.mutable.MutableFloat;
import jodd.mutable.MutableInteger;
import jodd.mutable.MutableLong;
import jodd.mutable.MutableShort;
import jodd.servlet.upload.FileUpload;
import jodd.typeconverter.BigDecimalConverter;
import jodd.typeconverter.BigIntegerConverter;
import jodd.typeconverter.BooleanArrayConverter;
import jodd.typeconverter.BooleanConverter;
import jodd.typeconverter.ByteArrayConverter;
import jodd.typeconverter.ByteConverter;
import jodd.typeconverter.CharacterConverter;
import jodd.typeconverter.ClassArrayConverter;
import jodd.typeconverter.ClassConverter;
import jodd.typeconverter.DoubleArrayConverter;
import jodd.typeconverter.DoubleConverter;
import jodd.typeconverter.FileUploadConverter;
import jodd.typeconverter.FloatArrayConverter;
import jodd.typeconverter.FloatConverter;
import jodd.typeconverter.IntegerArrayConverter;
import jodd.typeconverter.IntegerConverter;
import jodd.typeconverter.JDateTimeConverter;
import jodd.typeconverter.LongArrayConverter;
import jodd.typeconverter.LongConverter;
import jodd.typeconverter.MutableByteConverter;
import jodd.typeconverter.MutableDoubleConverter;
import jodd.typeconverter.MutableFloatConverter;
import jodd.typeconverter.MutableIntegerConverter;
import jodd.typeconverter.MutableLongConverter;
import jodd.typeconverter.MutableShortConverter;
import jodd.typeconverter.ShortArrayConverter;
import jodd.typeconverter.ShortConverter;
import jodd.typeconverter.SqlDateConverter;
import jodd.typeconverter.SqlTimeConverter;
import jodd.typeconverter.SqlTimestampConverter;
import jodd.typeconverter.StringArrayConverter;
import jodd.typeconverter.StringConverter;
import jodd.typeconverter.TypeConverter;
import jodd.typeconverter.URLConverter;

public class TypeConverterManager {
    private static HashMap<Class, TypeConverter> converters = new HashMap();

    public static void unregisterAll() {
        converters.clear();
    }

    public static void registerDefaults() {
        TypeConverterManager.register(String.class, new StringConverter());
        TypeConverterManager.register(String[].class, new StringArrayConverter());
        IntegerConverter integerConverter = new IntegerConverter();
        TypeConverterManager.register(Integer.class, integerConverter);
        TypeConverterManager.register(Integer.TYPE, integerConverter);
        TypeConverterManager.register(MutableInteger.class, new MutableIntegerConverter());
        ShortConverter shortConverter = new ShortConverter();
        TypeConverterManager.register(Short.class, shortConverter);
        TypeConverterManager.register(Short.TYPE, shortConverter);
        TypeConverterManager.register(MutableShort.class, new MutableShortConverter());
        LongConverter longConverter = new LongConverter();
        TypeConverterManager.register(Long.class, longConverter);
        TypeConverterManager.register(Long.TYPE, longConverter);
        TypeConverterManager.register(MutableLong.class, new MutableLongConverter());
        ByteConverter byteConverter = new ByteConverter();
        TypeConverterManager.register(Byte.class, byteConverter);
        TypeConverterManager.register(Byte.TYPE, byteConverter);
        TypeConverterManager.register(MutableByte.class, new MutableByteConverter());
        FloatConverter floatConverter = new FloatConverter();
        TypeConverterManager.register(Float.class, floatConverter);
        TypeConverterManager.register(Float.TYPE, floatConverter);
        TypeConverterManager.register(MutableFloat.class, new MutableFloatConverter());
        DoubleConverter doubleConverter = new DoubleConverter();
        TypeConverterManager.register(Double.class, doubleConverter);
        TypeConverterManager.register(Double.TYPE, doubleConverter);
        TypeConverterManager.register(MutableDouble.class, new MutableDoubleConverter());
        BooleanConverter booleanConverter = new BooleanConverter();
        TypeConverterManager.register(Boolean.class, booleanConverter);
        TypeConverterManager.register(Boolean.TYPE, booleanConverter);
        CharacterConverter characterConverter = new CharacterConverter();
        TypeConverterManager.register(Character.class, characterConverter);
        TypeConverterManager.register(Character.TYPE, characterConverter);
        TypeConverterManager.register(byte[].class, new ByteArrayConverter());
        TypeConverterManager.register(short[].class, new ShortArrayConverter());
        TypeConverterManager.register(int[].class, new IntegerArrayConverter());
        TypeConverterManager.register(long[].class, new LongArrayConverter());
        TypeConverterManager.register(float[].class, new FloatArrayConverter());
        TypeConverterManager.register(double[].class, new DoubleArrayConverter());
        TypeConverterManager.register(boolean[].class, new BooleanArrayConverter());
        TypeConverterManager.register(BigDecimal.class, new BigDecimalConverter());
        TypeConverterManager.register(BigInteger.class, new BigIntegerConverter());
        TypeConverterManager.register(Date.class, new SqlDateConverter());
        TypeConverterManager.register(Time.class, new SqlTimeConverter());
        TypeConverterManager.register(Timestamp.class, new SqlTimestampConverter());
        TypeConverterManager.register(FileUpload.class, new FileUploadConverter());
        TypeConverterManager.register(JDateTime.class, new JDateTimeConverter());
        TypeConverterManager.register(Class.class, new ClassConverter());
        TypeConverterManager.register(Class[].class, new ClassArrayConverter());
        TypeConverterManager.register(URL.class, new URLConverter());
    }

    public static void register(Class type, TypeConverter typeConverter) {
        converters.put(type, typeConverter);
    }

    public static void unregister(Class type) {
        converters.remove(type);
    }

    public static TypeConverter lookup(Class type) {
        return converters.get(type);
    }

    static {
        TypeConverterManager.registerDefaults();
    }
}

