/*
 * Decompiled with CFR 0.152.
 */
package jodd.swing.spy;

import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class SwingSpyGlassPane
extends JPanel
implements AWTEventListener {
    private final RootPaneContainer rootPaneContainer;
    private final Color fontColor;
    private final Color highlightColor;
    private final AlphaComposite alpha;
    private final Font font;
    private Point point;
    private Rectangle highcmp;

    public SwingSpyGlassPane(RootPaneContainer rootPaneContainer) {
        super(null);
        this.setName("SwingSpyGlass");
        this.rootPaneContainer = rootPaneContainer;
        this.fontColor = Color.RED.darker();
        this.highlightColor = new Color(0xFFDDDD);
        this.font = new Font("sansserif", 1, 14);
        this.alpha = AlphaComposite.getInstance(3, 0.5f);
        this.setOpaque(false);
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setComposite(this.alpha);
        if (this.highcmp != null) {
            g2.setColor(this.highlightColor);
            g2.fillRect((int)this.highcmp.getMinX(), (int)this.highcmp.getMinY(), (int)this.highcmp.getWidth(), (int)this.highcmp.getHeight());
        }
        if (this.point != null) {
            g2.setColor(this.fontColor);
            g2.setFont(this.font);
            g2.drawString("Spy", this.point.x + 15, this.point.y + 20);
        }
        g2.dispose();
    }

    public void eventDispatched(AWTEvent event) {
        if (event instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)event;
            Component mecmp = me.getComponent();
            if (!SwingUtilities.isDescendingFrom(mecmp, (Component)((Object)this.rootPaneContainer))) {
                return;
            }
            if (me.getID() == 505 && mecmp == this.rootPaneContainer) {
                this.highcmp = null;
                this.point = null;
            } else {
                MouseEvent converted = SwingUtilities.convertMouseEvent(mecmp, me, this);
                this.point = converted.getPoint();
                Rectangle rect = new Rectangle();
                rect.width = mecmp.getWidth();
                rect.height = mecmp.getHeight();
                Rectangle parentBounds = new Rectangle();
                for (Component parent = mecmp; parent != null && parent != this.getRootPane() && parent != this.rootPaneContainer; parent = parent.getParent()) {
                    parent.getBounds(parentBounds);
                    rect.x += parentBounds.x;
                    rect.y += parentBounds.y;
                }
                this.highcmp = rect;
            }
            this.repaint();
        }
    }

    public boolean contains(int x, int y) {
        if (this.getMouseListeners().length == 0 && this.getMouseMotionListeners().length == 0 && this.getMouseWheelListeners().length == 0 && this.getCursor() == Cursor.getPredefinedCursor(0)) {
            return false;
        }
        return super.contains(x, y);
    }
}

