/*
 * Decompiled with CFR 0.152.
 */
package jodd.servlet.tag;

import java.io.IOException;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.JspFragment;
import jodd.io.FastCharArrayWriter;

public class TagUtil {
    private static final String SCOPE_APPLICATION = "application";
    private static final String SCOPE_SESSION = "session";
    private static final String SCOPE_REQUEST = "request";
    private static final String SCOPE_PAGE = "page";

    public static void invokeBody(JspFragment body) throws JspException {
        if (body == null) {
            return;
        }
        try {
            body.invoke(null);
        }
        catch (IOException ioex) {
            throw new JspException("Unable to invoke tag body.", (Throwable)ioex);
        }
    }

    public static void invokeBody(JspFragment body, Writer writer) throws JspException {
        if (body == null) {
            return;
        }
        try {
            body.invoke(writer);
        }
        catch (IOException ioex) {
            throw new JspException("Unable to invoke tag body.", (Throwable)ioex);
        }
    }

    public static char[] renderBody(JspFragment body) throws JspException {
        FastCharArrayWriter writer = new FastCharArrayWriter();
        TagUtil.invokeBody(body, writer);
        return writer.toCharArray();
    }

    public static String renderBodyToString(JspFragment body) throws JspException {
        char[] result = TagUtil.renderBody(body);
        return new String(result);
    }

    public static void setScopeAttribute(String name, Object value, String scope, PageContext pageContext) throws JspException {
        String scopeValue;
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        String string = scopeValue = scope != null ? scope.toLowerCase() : SCOPE_PAGE;
        if (scopeValue.equals(SCOPE_PAGE)) {
            pageContext.setAttribute(name, value);
        } else if (scopeValue.equals(SCOPE_REQUEST)) {
            request.setAttribute(name, value);
        } else if (scopeValue.equals(SCOPE_SESSION)) {
            request.getSession().setAttribute(name, value);
        } else if (scopeValue.equals(SCOPE_APPLICATION)) {
            request.getSession().getServletContext().setAttribute(name, value);
        } else {
            throw new JspException("Invalid scope: '" + scope + "'.");
        }
    }

    public static void removeScopeAttribute(String name, String scope, PageContext pageContext) throws JspException {
        String scopeValue;
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        String string = scopeValue = scope != null ? scope.toLowerCase() : SCOPE_PAGE;
        if (scopeValue.equals(SCOPE_PAGE)) {
            pageContext.removeAttribute(name);
        } else if (scopeValue.equals(SCOPE_REQUEST)) {
            request.removeAttribute(name);
        } else if (scopeValue.equals(SCOPE_SESSION)) {
            request.getSession().removeAttribute(name);
        } else if (scopeValue.equals(SCOPE_APPLICATION)) {
            request.getSession().getServletContext().removeAttribute(name);
        } else {
            throw new JspException("Invalid scope: '" + scope + "'.");
        }
    }
}

