/*
 * Decompiled with CFR 0.152.
 */
package jodd.cache;

import java.util.Iterator;
import java.util.LinkedHashMap;
import jodd.cache.AbstractCacheMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FIFOCache<K, V>
extends AbstractCacheMap<K, V> {
    public FIFOCache(int cacheSize) {
        this(cacheSize, 0L);
    }

    public FIFOCache(int cacheSize, long timeout) {
        this.cacheSize = cacheSize;
        this.timeout = timeout;
        this.cacheMap = new LinkedHashMap(cacheSize + 1, 1.0f, false);
    }

    @Override
    public int prune() {
        int count = 0;
        AbstractCacheMap.CacheObject first = null;
        Iterator values = this.cacheMap.values().iterator();
        while (values.hasNext()) {
            AbstractCacheMap.CacheObject co = (AbstractCacheMap.CacheObject)values.next();
            if (co.isExpired()) {
                values.remove();
                ++count;
            }
            if (first != null) continue;
            first = co;
        }
        if (this.isFull() && first != null) {
            this.cacheMap.remove(first.key);
            ++count;
        }
        return count;
    }
}

