/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.support.parallel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.compass.core.CompassSession;
import org.compass.core.spi.InternalCompass;
import org.compass.gps.CompassGpsException;
import org.compass.gps.IndexPlan;
import org.compass.gps.device.AbstractGpsDevice;
import org.compass.gps.device.support.parallel.ConcurrentParallelIndexExecutor;
import org.compass.gps.device.support.parallel.IndexEntitiesIndexer;
import org.compass.gps.device.support.parallel.IndexEntitiesPartitioner;
import org.compass.gps.device.support.parallel.IndexEntity;
import org.compass.gps.device.support.parallel.ParallelIndexExecutor;
import org.compass.gps.device.support.parallel.SubIndexIndexEntitiesPartitioner;
import org.compass.gps.spi.CompassGpsInterfaceDevice;

public abstract class AbstractParallelGpsDevice
extends AbstractGpsDevice {
    private ParallelIndexExecutor parallelIndexExecutor = new ConcurrentParallelIndexExecutor();
    private IndexEntitiesPartitioner indexEntitiesPartitioner = new SubIndexIndexEntitiesPartitioner();
    private volatile IndexEntity[][] entities;
    private IndexEntitiesIndexer indexEntitiesIndexer;

    public synchronized void start() throws CompassGpsException {
        super.start();
        this.indexEntitiesIndexer = this.doGetIndexEntitiesIndexer();
    }

    public synchronized void index(IndexPlan indexPlan) throws CompassGpsException {
        if (!this.isRunning()) {
            throw new IllegalStateException(this.buildMessage("must be running in order to perform the index operation"));
        }
        this.entities = this.indexEntitiesPartitioner.partition(this.doGetIndexEntities());
        String[] arrSubIndexes = ((InternalCompass)((CompassGpsInterfaceDevice)this.getGps()).getIndexCompass()).getSearchEngineFactory().getIndexManager().polyCalcSubIndexes(indexPlan.getSubIndexes(), indexPlan.getAliases(), indexPlan.getTypes());
        HashSet<String> subIndexes = new HashSet<String>(Arrays.asList(arrSubIndexes));
        ArrayList<IndexEntity[]> calcEntities = new ArrayList<IndexEntity[]>();
        for (IndexEntity[] arrEleEntities : this.entities) {
            boolean found = false;
            for (IndexEntity entity : arrEleEntities) {
                for (String subIndex : entity.getSubIndexes()) {
                    if (!subIndexes.contains(subIndex)) continue;
                    found = true;
                    break;
                }
                if (found) break;
            }
            if (!found) continue;
            calcEntities.add(arrEleEntities);
        }
        IndexEntity[][] entitiesToIndex = (IndexEntity[][])calcEntities.toArray((T[])new IndexEntity[calcEntities.size()][]);
        this.parallelIndexExecutor.performIndex(entitiesToIndex, this.indexEntitiesIndexer, this.compassGps);
    }

    protected abstract IndexEntity[] doGetIndexEntities() throws CompassGpsException;

    protected abstract IndexEntitiesIndexer doGetIndexEntitiesIndexer();

    protected final void doIndex(CompassSession session, IndexPlan indexPlan) throws CompassGpsException {
        throw new IllegalStateException("This should not be called");
    }

    public void setParallelIndexExecutor(ParallelIndexExecutor parallelIndexExecutor) {
        this.parallelIndexExecutor = parallelIndexExecutor;
    }

    public void setIndexEntitiesPartitioner(IndexEntitiesPartitioner indexEntitiesPartitioner) {
        this.indexEntitiesPartitioner = indexEntitiesPartitioner;
    }
}

