/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import javax.sql.DataSource;
import org.compass.core.CompassException;
import org.compass.core.Property;
import org.compass.core.config.InputStreamMappingResolver;
import org.compass.core.mapping.ExcludeFromAll;
import org.compass.gps.device.jdbc.JdbcGpsDeviceException;
import org.compass.gps.device.jdbc.mapping.AutoGenerateMapping;
import org.compass.gps.device.jdbc.mapping.ColumnToPropertyMapping;
import org.compass.gps.device.jdbc.mapping.DataColumnToPropertyMapping;
import org.compass.gps.device.jdbc.mapping.IdColumnToPropertyMapping;
import org.compass.gps.device.jdbc.mapping.ResultSetToResourceMapping;

public class ResultSetResourceMappingResolver
implements InputStreamMappingResolver {
    private ResultSetToResourceMapping mapping;
    private DataSource dataSource;
    private String subIndex;
    private boolean all = true;
    private String allMetaData;
    private Property.TermVector allTermVector;

    public ResultSetResourceMappingResolver() {
    }

    public ResultSetResourceMappingResolver(ResultSetToResourceMapping mapping, DataSource dataSource) {
        this.mapping = mapping;
        this.dataSource = dataSource;
    }

    public String getName() {
        return "" + this.subIndex + ".cpm.xml";
    }

    public InputStream getMappingAsInputStream() throws CompassException {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\"?>");
        sb.append("<!DOCTYPE compass-core-mapping PUBLIC ");
        sb.append("    \"-//Compass/Compass Core Mapping DTD 2.2//EN\"");
        sb.append("    \"http://www.compass-project.org/dtd/compass-core-mapping-2.2.dtd\">");
        sb.append("<compass-core-mapping>");
        sb.append("    <resource alias=\"").append(this.mapping.getAlias()).append("\"");
        if (this.subIndex != null) {
            sb.append(" sub-index=\"").append(this.subIndex).append("\"");
        }
        sb.append(" >");
        sb.append("<all enable=\"").append(this.all).append("\" ");
        if (this.allMetaData != null) {
            sb.append(" name=\"").append(this.allMetaData).append("\"");
        }
        if (this.allTermVector != null) {
            sb.append(" term-vector=\"").append(Property.TermVector.toString(this.allTermVector)).append("\"");
        }
        sb.append(" />");
        if (this.mapping.idMappingsSize() == 0) {
            if (this.mapping instanceof AutoGenerateMapping) {
                ((AutoGenerateMapping)((Object)this.mapping)).generateMappings(this.dataSource);
            }
            if (this.mapping.idMappingsSize() == 0) {
                throw new JdbcGpsDeviceException("Can not generate resource mapping with no id to column mappings defined");
            }
        }
        Iterator it = this.mapping.idMappingsIt();
        while (it.hasNext()) {
            IdColumnToPropertyMapping idMapping = (IdColumnToPropertyMapping)it.next();
            this.generateResourceIdMapping("resource-id", idMapping, sb);
        }
        it = this.mapping.dataMappingsIt();
        while (it.hasNext()) {
            DataColumnToPropertyMapping dataMapping = (DataColumnToPropertyMapping)it.next();
            this.generateResourceProperyMapping("resource-property", dataMapping, sb);
        }
        sb.append("    </resource>");
        sb.append("</compass-core-mapping>");
        return new ByteArrayInputStream(sb.toString().getBytes());
    }

    private void generateResourceIdMapping(String tag, ColumnToPropertyMapping mapping, StringBuffer sb) {
        sb.append("<").append(tag).append(" ");
        sb.append("name=\"").append(mapping.getPropertyName()).append("\"").append(" ");
        if (mapping.getAnalyzer() != null) {
            sb.append("analyzer=\"").append(mapping.getAnalyzer()).append("\"").append(" ");
        }
        if (mapping.getConverter() != null) {
            sb.append("converter=\"").append(mapping.getConverter()).append("\"").append(" ");
        }
        if (mapping.getBoost() > 0.0f) {
            sb.append("boost=\"").append(mapping.getBoost()).append("\"").append(" ");
        }
        sb.append(" />");
    }

    private void generateResourceProperyMapping(String tag, ColumnToPropertyMapping mapping, StringBuffer sb) {
        sb.append("<").append(tag).append(" ");
        sb.append("name=\"").append(mapping.getPropertyName()).append("\"").append(" ");
        sb.append("index=\"").append(Property.Index.toString(mapping.getPropertyIndex())).append("\"").append(" ");
        sb.append("store=\"").append(Property.Store.toString(mapping.getPropertyStore())).append("\"").append(" ");
        sb.append("term-vector=\"").append(Property.TermVector.toString(mapping.getPropertyTermVector())).append("\"").append(" ");
        sb.append("exclude-from-all=\"").append(ExcludeFromAll.toString(mapping.getExcludeFromAll())).append("\"").append(" ");
        if (mapping.getAnalyzer() != null) {
            sb.append("analyzer=\"").append(mapping.getAnalyzer()).append("\"").append(" ");
        }
        if (mapping.getConverter() != null) {
            sb.append("converter=\"").append(mapping.getConverter()).append("\"").append(" ");
        }
        if (mapping.getBoost() > 0.0f) {
            sb.append("boost=\"").append(mapping.getBoost()).append("\"").append(" ");
        }
        sb.append(" />");
    }

    public ResultSetToResourceMapping getMapping() {
        return this.mapping;
    }

    public void setMapping(ResultSetToResourceMapping mapping) {
        this.mapping = mapping;
    }

    public String getSubIndex() {
        return this.subIndex;
    }

    public void setSubIndex(String subIndex) {
        this.subIndex = subIndex;
    }

    public boolean isAll() {
        return this.all;
    }

    public void setAll(boolean all) {
        this.all = all;
    }

    public String getAllMetaData() {
        return this.allMetaData;
    }

    public void setAllMetaData(String allMetaData) {
        this.allMetaData = allMetaData;
    }

    public Property.TermVector getAllTermVector() {
        return this.allTermVector;
    }

    public void setAllTermVector(Property.TermVector allTermVector) {
        this.allTermVector = allTermVector;
    }

    public void setAllTermVectorString(String allTermVector) {
        this.allTermVector = Property.TermVector.fromString(allTermVector);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

