/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.basic;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.converter.ConversionException;
import org.compass.core.converter.basic.AbstractFormatConverter;
import org.compass.core.converter.basic.format.Formatter;
import org.compass.core.converter.basic.format.FormatterFactory;
import org.compass.core.converter.basic.format.TextFormatFormatter;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.marshall.MarshallingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNumberConverter<N extends Number>
extends AbstractFormatConverter<N>
implements CompassConfigurable {
    public static final String SORTABLE_FORMAT = "sortable";

    @Override
    protected FormatterFactory doCreateFormatterFactory() {
        return new NumberFormatter();
    }

    protected abstract N defaultFromString(String var1, ResourcePropertyMapping var2);

    protected abstract N fromNumber(Number var1);

    protected abstract Formatter createSortableFormatter();

    @Override
    protected N doFromString(String str, ResourcePropertyMapping resourcePropertyMapping, MarshallingContext context) throws ConversionException {
        if (this.hasFormatter) {
            ParseException pe = null;
            for (Formatter formatter : this.formatters) {
                try {
                    return this.fromNumber((Number)formatter.parse(str));
                }
                catch (ParseException e) {
                    pe = e;
                }
            }
            throw new ConversionException("Failed to parse number [" + str + "]", pe);
        }
        return this.defaultFromString(str, resourcePropertyMapping);
    }

    @Override
    protected String doToString(N o, ResourcePropertyMapping resourcePropertyMapping, MarshallingContext context) {
        if (this.hasFormatter) {
            return this.formatters[0].format(o);
        }
        return this.defaultToString(o, resourcePropertyMapping, context);
    }

    protected String defaultToString(N o, ResourcePropertyMapping resourcePropertyMapping, MarshallingContext context) {
        return super.doToString(o, resourcePropertyMapping, context);
    }

    private class NumberFormatter
    implements FormatterFactory {
        private String format;
        private Locale locale;

        private NumberFormatter() {
        }

        public void configure(String format, Locale locale) {
            this.format = format;
            this.locale = locale;
        }

        public Formatter create() {
            if (AbstractNumberConverter.SORTABLE_FORMAT.equalsIgnoreCase(this.format)) {
                Formatter formatter = AbstractNumberConverter.this.createSortableFormatter();
                if (formatter == null) {
                    throw new ConversionException("This converter [" + this.getClass().getName() + "] does not support sortable format");
                }
                return formatter;
            }
            NumberFormat numberFormat = this.locale != null ? NumberFormat.getInstance(this.locale) : NumberFormat.getInstance();
            ((DecimalFormat)numberFormat).applyPattern(this.format);
            return new TextFormatFormatter(numberFormat);
        }
    }
}

