/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config.process;

import java.util.ArrayList;
import java.util.Iterator;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.process.MappingProcessor;
import org.compass.core.converter.ConverterLookup;
import org.compass.core.engine.naming.PropertyNamingStrategy;
import org.compass.core.mapping.AliasMapping;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.MappingException;
import org.compass.core.mapping.internal.InternalCompassMapping;
import org.compass.core.mapping.json.JsonArrayMapping;
import org.compass.core.mapping.json.JsonContentMapping;
import org.compass.core.mapping.json.JsonIdMapping;
import org.compass.core.mapping.json.JsonMapping;
import org.compass.core.mapping.json.JsonMappingIterator;
import org.compass.core.mapping.json.JsonPropertyMapping;
import org.compass.core.mapping.json.PlainJsonObjectMapping;
import org.compass.core.mapping.json.RootJsonObjectMapping;

public class LateBindingJsonMappingProcessor
implements MappingProcessor {
    private PropertyNamingStrategy namingStrategy;

    public CompassMapping process(CompassMapping compassMapping, PropertyNamingStrategy namingStrategy, ConverterLookup converterLookup, CompassSettings settings) throws MappingException {
        this.namingStrategy = namingStrategy;
        ((InternalCompassMapping)compassMapping).setPath(namingStrategy.getRootPath());
        for (AliasMapping aliasMapping : compassMapping.getMappings()) {
            if (!(aliasMapping instanceof RootJsonObjectMapping)) continue;
            this.secondPass((RootJsonObjectMapping)aliasMapping, compassMapping);
        }
        return compassMapping;
    }

    private void secondPass(RootJsonObjectMapping rootJsonObjectMapping, CompassMapping fatherMapping) {
        rootJsonObjectMapping.setPath(this.namingStrategy.buildPath(fatherMapping.getPath(), rootJsonObjectMapping.getAlias()));
        Iterator<Mapping> it = rootJsonObjectMapping.mappingsIt();
        while (it.hasNext()) {
            Mapping mapping = it.next();
            if (!(mapping instanceof JsonIdMapping)) continue;
            JsonIdMapping jsonIdMapping = (JsonIdMapping)mapping;
            jsonIdMapping.setInternal(true);
            jsonIdMapping.setPath(this.namingStrategy.buildPath(rootJsonObjectMapping.getPath(), jsonIdMapping.getName()));
        }
        JsonMappingIterator.iterateMappings((JsonMappingIterator.JsonMappingCallback)new FullPathCallback(), rootJsonObjectMapping, true);
    }

    private class FullPathCallback
    implements JsonMappingIterator.JsonMappingCallback {
        private ArrayList<String> pathSteps = new ArrayList();
        private StringBuilder sb = new StringBuilder();

        private FullPathCallback() {
        }

        public void onJsonRootObject(RootJsonObjectMapping jsonObjectMapping) {
            jsonObjectMapping.setFullPath("");
        }

        public void onJsonObject(PlainJsonObjectMapping jsonObjectMapping) {
            this.addToPath(jsonObjectMapping);
            jsonObjectMapping.setFullPath(this.currentPath());
            this.removeFromPath(jsonObjectMapping);
        }

        public void onJsonContent(JsonContentMapping jsonContentMapping) {
            this.addToPath(jsonContentMapping);
            jsonContentMapping.setFullPath(this.currentPath());
            this.removeFromPath(jsonContentMapping);
        }

        public void onJsonProperty(JsonPropertyMapping jsonPropertyMapping) {
            this.addToPath(jsonPropertyMapping);
            jsonPropertyMapping.setFullPath(this.currentPath());
            this.removeFromPath(jsonPropertyMapping);
        }

        public void onJsonArray(JsonArrayMapping jsonArrayMapping) {
            this.addToPath(jsonArrayMapping);
            jsonArrayMapping.setFullPath(this.currentPath());
            this.removeFromPath(jsonArrayMapping);
        }

        public boolean onBeginMultipleMapping(JsonMapping mapping) {
            this.addToPath(mapping);
            return true;
        }

        public void onEndMultipleMapping(JsonMapping mapping) {
            this.removeFromPath(mapping);
        }

        private void addToPath(JsonMapping mapping) {
            if (mapping instanceof RootJsonObjectMapping) {
                return;
            }
            String name = mapping.getName();
            if (name == null) {
                throw new IllegalStateException("Internal error in Compass");
            }
            this.pathSteps.add(name);
        }

        private void removeFromPath(JsonMapping mapping) {
            if (mapping instanceof RootJsonObjectMapping) {
                return;
            }
            if (this.pathSteps.size() > 0) {
                this.pathSteps.remove(this.pathSteps.size() - 1);
            }
        }

        private String currentPath() {
            this.sb.setLength(0);
            for (int i = 0; i < this.pathSteps.size(); ++i) {
                if (i > 0) {
                    this.sb.append('.');
                }
                this.sb.append(this.pathSteps.get(i));
            }
            return this.sb.toString();
        }
    }
}

