/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.http.TunnelUtil;
import com.liferay.portlet.shopping.model.ShoppingCategory;
import com.liferay.portlet.shopping.service.ShoppingCategoryServiceUtil;

public class ShoppingCategoryServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(ShoppingCategoryServiceHttp.class);

    public static ShoppingCategory addCategory(HttpPrincipal httpPrincipal, long parentCategoryId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(ShoppingCategoryServiceUtil.class.getName(), "addCategory", new Class[]{Long.TYPE, String.class, String.class, ServiceContext.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{parentCategoryId, name, description, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (ShoppingCategory)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteCategory(HttpPrincipal httpPrincipal, long categoryId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(ShoppingCategoryServiceUtil.class.getName(), "deleteCategory", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{categoryId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static ShoppingCategory getCategory(HttpPrincipal httpPrincipal, long categoryId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(ShoppingCategoryServiceUtil.class.getName(), "getCategory", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{categoryId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (ShoppingCategory)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static ShoppingCategory updateCategory(HttpPrincipal httpPrincipal, long categoryId, long parentCategoryId, String name, String description, boolean mergeWithParentCategory, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(ShoppingCategoryServiceUtil.class.getName(), "updateCategory", new Class[]{Long.TYPE, Long.TYPE, String.class, String.class, Boolean.TYPE, ServiceContext.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{categoryId, parentCategoryId, name, description, mergeWithParentCategory, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (ShoppingCategory)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

