/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.util;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.model.Company;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.ContentUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.journal.util.BaseTemplateParser;
import com.liferay.portlet.journal.util.URIResolver;
import com.liferay.portlet.journal.util.XSLErrorListener;
import com.liferay.util.PwdGenerator;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Locale;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSLTemplateParser
extends BaseTemplateParser {
    @Override
    protected String doTransform(ThemeDisplay themeDisplay, Map<String, String> tokens, String viewMode, String languageId, String xml, String script) throws Exception {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        long companyId = GetterUtil.getLong((String)tokens.get("company_id"));
        Company company = CompanyLocalServiceUtil.getCompanyById((long)companyId);
        long groupId = GetterUtil.getLong((String)tokens.get("group_id"));
        String journalTemplatesPath = "_JOURNAL_CONTEXT_/" + companyId + "/" + groupId;
        String randomNamespace = String.valueOf(PwdGenerator.getPassword((String)PwdGenerator.KEY3, (int)4)) + "_";
        Locale locale = LocaleUtil.fromLanguageId((String)languageId);
        XSLErrorListener xslErrorListener = new XSLErrorListener(locale);
        StreamSource xmlSource = new StreamSource((Reader)new UnsyncStringReader(xml));
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setURIResolver(new URIResolver(tokens, languageId));
        transformerFactory.setErrorListener(xslErrorListener);
        try {
            StreamSource scriptSource = new StreamSource((Reader)new UnsyncStringReader(script));
            Transformer transformer = transformerFactory.newTransformer(scriptSource);
            transformer.setParameter("company", company);
            transformer.setParameter("companyId", new Long(companyId));
            transformer.setParameter("groupId", String.valueOf(groupId));
            transformer.setParameter("journalTemplatesPath", journalTemplatesPath);
            transformer.setParameter("viewMode", viewMode);
            transformer.setParameter("locale", locale);
            transformer.setParameter("permissionChecker", PermissionThreadLocal.getPermissionChecker());
            transformer.setParameter("randomNamespace", randomNamespace);
            transformer.transform(xmlSource, new StreamResult((OutputStream)unsyncByteArrayOutputStream));
        }
        catch (Exception exception) {
            String errorTemplate = ContentUtil.get(PropsValues.JOURNAL_ERROR_TEMPLATE_XSL);
            StreamSource scriptSource = new StreamSource((Reader)new UnsyncStringReader(errorTemplate));
            Transformer transformer = transformerFactory.newTransformer(scriptSource);
            transformer.setParameter("company", company);
            transformer.setParameter("companyId", new Long(companyId));
            transformer.setParameter("groupId", String.valueOf(groupId));
            transformer.setParameter("journalTemplatesPath", journalTemplatesPath);
            transformer.setParameter("locale", locale);
            transformer.setParameter("randomNamespace", randomNamespace);
            transformer.setParameter("exception", xslErrorListener.getMessageAndLocation());
            transformer.setParameter("script", script);
            if (xslErrorListener.getLocation() != null) {
                transformer.setParameter("column", new Integer(xslErrorListener.getColumnNumber()));
                transformer.setParameter("line", new Integer(xslErrorListener.getLineNumber()));
            }
            transformer.transform(xmlSource, new StreamResult((OutputStream)unsyncByteArrayOutputStream));
        }
        return unsyncByteArrayOutputStream.toString("UTF-8");
    }
}

