/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.imagegallery.util;

import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.imagegallery.model.IGFolder;
import com.liferay.portlet.imagegallery.model.IGImage;
import com.liferay.portlet.imagegallery.service.IGFolderLocalServiceUtil;
import java.util.Collections;
import java.util.List;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class IGUtil {
    public static void addPortletBreadcrumbEntries(IGImage image, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        IGFolder folder = image.getFolder();
        IGUtil.addPortletBreadcrumbEntries(folder, request, renderResponse);
        PortletURL portletURL = renderResponse.createRenderURL();
        portletURL.setParameter("struts_action", "/image_gallery/view_image");
        portletURL.setParameter("imageId", String.valueOf(image.getImageId()));
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)image.getName(), (String)portletURL.toString());
    }

    public static void addPortletBreadcrumbEntries(long folderId, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        if (folderId == 0L) {
            return;
        }
        IGFolder folder = IGFolderLocalServiceUtil.getFolder((long)folderId);
        IGUtil.addPortletBreadcrumbEntries(folder, request, renderResponse);
    }

    public static void addPortletBreadcrumbEntries(IGFolder folder, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        String strutsAction = ParamUtil.getString((HttpServletRequest)request, (String)"struts_action");
        PortletURL portletURL = renderResponse.createRenderURL();
        if (strutsAction.equals("/journal/select_image_gallery") || strutsAction.equals("/image_gallery/select_folder")) {
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
            portletURL.setWindowState(LiferayWindowState.POP_UP);
            portletURL.setParameter("struts_action", strutsAction);
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)themeDisplay.translate("images-home"), (String)portletURL.toString());
        } else {
            portletURL.setParameter("struts_action", "/image_gallery/view");
        }
        List ancestorFolders = folder.getAncestors();
        Collections.reverse(ancestorFolders);
        for (IGFolder ancestorFolder : ancestorFolders) {
            portletURL.setParameter("folderId", String.valueOf(ancestorFolder.getFolderId()));
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)ancestorFolder.getName(), (String)portletURL.toString());
        }
        portletURL.setParameter("folderId", String.valueOf(folder.getFolderId()));
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)folder.getName(), (String)portletURL.toString());
    }
}

