/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.documentlibrary.DuplicateFileException;
import com.liferay.documentlibrary.FileSizeException;
import com.liferay.documentlibrary.NoSuchFileException;
import com.liferay.documentlibrary.util.JCRHook;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.NoSuchEntryException;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.documentlibrary.DuplicateFolderNameException;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.NoSuchFileVersionException;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.model.impl.DLFileEntryImpl;
import com.liferay.portlet.documentlibrary.service.base.DLFileEntryLocalServiceBaseImpl;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.documentlibrary.util.comparator.FileEntryModifiedDateComparator;
import com.liferay.portlet.messageboards.model.MBDiscussion;
import com.liferay.portlet.ratings.model.RatingsEntry;
import com.liferay.portlet.ratings.model.RatingsStats;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLFileEntryLocalServiceImpl
extends DLFileEntryLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(DLFileEntryLocalServiceImpl.class);

    public DLFileEntry addFileEntry(long userId, long groupId, long folderId, String name, String title, String description, String changeLog, String extraSettings, byte[] bytes, ServiceContext serviceContext) throws PortalException, SystemException {
        if (bytes == null) {
            throw new FileSizeException();
        }
        UnsyncByteArrayInputStream is = new UnsyncByteArrayInputStream(bytes);
        return this.addFileEntry(userId, groupId, folderId, name, title, description, changeLog, extraSettings, (InputStream)is, bytes.length, serviceContext);
    }

    public DLFileEntry addFileEntry(long userId, long groupId, long folderId, String name, String title, String description, String changeLog, String extraSettings, File file, ServiceContext serviceContext) throws PortalException, SystemException {
        if (file == null) {
            throw new FileSizeException();
        }
        try {
            UnsyncBufferedInputStream is = new UnsyncBufferedInputStream((InputStream)new FileInputStream(file));
            return this.addFileEntry(userId, groupId, folderId, name, title, description, changeLog, extraSettings, (InputStream)is, file.length(), serviceContext);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileSizeException();
        }
    }

    public DLFileEntry addFileEntry(long userId, long groupId, long folderId, String name, String title, String description, String changeLog, String extraSettings, InputStream is, long size, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        folderId = this.getFolderId(user.getCompanyId(), folderId);
        String extension = FileUtil.getExtension((String)name);
        if (Validator.isNull((String)title)) {
            title = name;
        }
        name = String.valueOf(this.counterLocalService.increment(DLFileEntry.class.getName()));
        Date now = new Date();
        this.validate(groupId, folderId, title, is);
        long fileEntryId = this.counterLocalService.increment();
        DLFileEntry fileEntry = this.dlFileEntryPersistence.create(fileEntryId);
        fileEntry.setUuid(serviceContext.getUuid());
        fileEntry.setGroupId(groupId);
        fileEntry.setCompanyId(user.getCompanyId());
        fileEntry.setUserId(user.getUserId());
        fileEntry.setUserName(user.getFullName());
        fileEntry.setVersionUserId(user.getUserId());
        fileEntry.setVersionUserName(user.getFullName());
        fileEntry.setCreateDate(serviceContext.getCreateDate(now));
        fileEntry.setModifiedDate(serviceContext.getModifiedDate(now));
        fileEntry.setFolderId(folderId);
        fileEntry.setName(name);
        fileEntry.setExtension(extension);
        fileEntry.setTitle(title);
        fileEntry.setDescription(description);
        fileEntry.setExtraSettings(extraSettings);
        fileEntry.setVersion("1.0");
        fileEntry.setSize(size);
        fileEntry.setReadCount(0);
        this.dlFileEntryPersistence.update((BaseModel)fileEntry, false);
        if (serviceContext.getAddCommunityPermissions() || serviceContext.getAddGuestPermissions()) {
            this.addFileEntryResources(fileEntry, serviceContext.getAddCommunityPermissions(), serviceContext.getAddGuestPermissions());
        } else {
            this.addFileEntryResources(fileEntry, serviceContext.getCommunityPermissions(), serviceContext.getGuestPermissions());
        }
        DLFileVersion fileVersion = this.addFileVersion(user, fileEntry, serviceContext.getModifiedDate(now), extension, title, description, null, extraSettings, "1.0", size, 2, serviceContext);
        if (folderId != 0L) {
            DLFolder folder = this.dlFolderPersistence.findByPrimaryKey(folderId);
            folder.setLastPostDate(fileEntry.getModifiedDate());
            this.dlFolderPersistence.update((BaseModel)folder, false);
        }
        this.updateAsset(userId, fileEntry, fileVersion, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        if (PropsValues.DL_FILE_ENTRY_COMMENTS_ENABLED) {
            this.mbMessageLocalService.addDiscussionMessage(userId, fileEntry.getUserName(), groupId, DLFileEntry.class.getName(), fileEntryId, 1);
        }
        this.dlLocalService.addFile(user.getCompanyId(), "20", fileEntry.getGroupId(), fileEntry.getRepositoryId(), name, false, fileEntryId, fileEntry.getLuceneProperties(), fileEntry.getModifiedDate(), serviceContext, is);
        WorkflowHandlerRegistryUtil.startWorkflowInstance((long)user.getCompanyId(), (long)groupId, (long)userId, (String)DLFileEntry.class.getName(), (long)fileEntryId, (Object)fileEntry, (ServiceContext)serviceContext);
        return fileEntry;
    }

    public void addFileEntryResources(DLFileEntry fileEntry, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(fileEntry.getCompanyId(), fileEntry.getGroupId(), fileEntry.getUserId(), DLFileEntry.class.getName(), fileEntry.getFileEntryId(), false, addCommunityPermissions, addGuestPermissions);
    }

    public void addFileEntryResources(DLFileEntry fileEntry, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(fileEntry.getCompanyId(), fileEntry.getGroupId(), fileEntry.getUserId(), DLFileEntry.class.getName(), fileEntry.getFileEntryId(), communityPermissions, guestPermissions);
    }

    public void addFileEntryResources(long fileEntryId, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        DLFileEntry fileEntry = this.dlFileEntryPersistence.findByPrimaryKey(fileEntryId);
        this.addFileEntryResources(fileEntry, addCommunityPermissions, addGuestPermissions);
    }

    public void addFileEntryResources(long fileEntryId, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        DLFileEntry fileEntry = this.dlFileEntryPersistence.findByPrimaryKey(fileEntryId);
        this.addFileEntryResources(fileEntry, communityPermissions, guestPermissions);
    }

    public DLFileEntry addOrOverwriteFileEntry(long userId, long groupId, long folderId, String name, String sourceName, String title, String description, String changeLog, String extraSettings, File file, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            this.dlFileEntryPersistence.findByG_F_T(groupId, folderId, title);
            return this.updateFileEntry(userId, groupId, folderId, name, sourceName, title, description, changeLog, false, extraSettings, file, serviceContext);
        }
        catch (NoSuchFileEntryException noSuchFileEntryException) {
            return this.addFileEntry(userId, groupId, folderId, name, title, description, changeLog, extraSettings, file, serviceContext);
        }
    }

    public void deleteFileEntries(long groupId, long folderId) throws PortalException, SystemException {
        List fileEntries = this.dlFileEntryPersistence.findByG_F(groupId, folderId);
        for (DLFileEntry fileEntry : fileEntries) {
            this.deleteFileEntry(fileEntry);
        }
    }

    public void deleteFileEntry(DLFileEntry fileEntry) throws PortalException, SystemException {
        block3: {
            this.dlFileEntryPersistence.remove((BaseModel)fileEntry);
            this.resourceLocalService.deleteResource(fileEntry.getCompanyId(), DLFileEntry.class.getName(), 4, fileEntry.getFileEntryId());
            this.webDAVPropsLocalService.deleteWebDAVProps(DLFileEntry.class.getName(), fileEntry.getFileEntryId());
            this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(fileEntry.getCompanyId(), fileEntry.getGroupId(), DLFileEntry.class.getName(), fileEntry.getFileEntryId());
            this.dlFileRankLocalService.deleteFileRanks(fileEntry.getFolderId(), fileEntry.getName());
            this.dlFileShortcutLocalService.deleteFileShortcuts(fileEntry.getGroupId(), fileEntry.getFolderId(), fileEntry.getName());
            List fileVersions = this.dlFileVersionPersistence.findByG_F_N(fileEntry.getGroupId(), fileEntry.getFolderId(), fileEntry.getName());
            for (DLFileVersion fileVersion : fileVersions) {
                this.dlFileVersionPersistence.remove((BaseModel)fileVersion);
            }
            this.assetEntryLocalService.deleteEntry(DLFileEntry.class.getName(), fileEntry.getFileEntryId());
            this.expandoValueLocalService.deleteValues(DLFileEntry.class.getName(), fileEntry.getFileEntryId());
            String lockId = DLUtil.getLockId((long)fileEntry.getGroupId(), (long)fileEntry.getFolderId(), (String)fileEntry.getName());
            this.lockLocalService.unlock(DLFileEntry.class.getName(), lockId);
            this.mbMessageLocalService.deleteDiscussionMessages(DLFileEntry.class.getName(), fileEntry.getFileEntryId());
            this.ratingsStatsLocalService.deleteStats(DLFileEntry.class.getName(), fileEntry.getFileEntryId());
            this.socialActivityLocalService.deleteActivities(DLFileEntry.class.getName(), fileEntry.getFileEntryId());
            try {
                this.dlService.deleteFile(fileEntry.getCompanyId(), "20", fileEntry.getRepositoryId(), fileEntry.getName());
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)e, (Throwable)e);
            }
        }
    }

    public void deleteFileEntry(long groupId, long folderId, String name) throws PortalException, SystemException {
        this.deleteFileEntry(groupId, folderId, name, null);
    }

    public void deleteFileEntry(long groupId, long folderId, String name, String version) throws PortalException, SystemException {
        DLFileEntry fileEntry = this.dlFileEntryPersistence.findByG_F_N(groupId, folderId, name);
        if (Validator.isNotNull((String)version)) {
            block9: {
                try {
                    this.dlService.deleteFile(fileEntry.getCompanyId(), "20", fileEntry.getRepositoryId(), fileEntry.getName(), version);
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block9;
                    _log.warn((Object)e, (Throwable)e);
                }
            }
            long fileVersionsCount = this.dlFileVersionPersistence.countByG_F_N(groupId, folderId, name);
            this.dlFileVersionPersistence.removeByG_F_N_V(groupId, folderId, name, version);
            if (fileVersionsCount == 1L) {
                this.dlFileEntryPersistence.remove((BaseModel)fileEntry);
            } else {
                if (version.equals(fileEntry.getVersion())) {
                    try {
                        DLFileVersion fileVersion = this.dlFileVersionLocalService.getLatestFileVersion(groupId, folderId, name);
                        fileEntry.setVersion(fileVersion.getVersion());
                        fileEntry.setSize(fileVersion.getSize());
                    }
                    catch (NoSuchFileVersionException noSuchFileVersionException) {}
                }
                this.dlFileEntryPersistence.update((BaseModel)fileEntry, false);
            }
        } else {
            this.deleteFileEntry(fileEntry);
        }
    }

    public List<DLFileEntry> getCompanyFileEntries(long companyId, int start, int end) throws SystemException {
        return this.dlFileEntryPersistence.findByCompanyId(companyId, start, end);
    }

    public List<DLFileEntry> getCompanyFileEntries(long companyId, int start, int end, OrderByComparator obc) throws SystemException {
        return this.dlFileEntryPersistence.findByCompanyId(companyId, start, end, obc);
    }

    public int getCompanyFileEntriesCount(long companyId) throws SystemException {
        return this.dlFileEntryPersistence.countByCompanyId(companyId);
    }

    public InputStream getFileAsStream(long companyId, long userId, long groupId, long folderId, String name) throws PortalException, SystemException {
        return this.getFileAsStream(companyId, userId, groupId, folderId, name, "");
    }

    public InputStream getFileAsStream(long companyId, long userId, long groupId, long folderId, String name, String version) throws PortalException, SystemException {
        DLFileEntry fileEntry = this.dlFileEntryPersistence.findByG_F_N(groupId, folderId, name);
        if (userId > 0L) {
            this.dlFileRankLocalService.updateFileRank(groupId, companyId, userId, folderId, name, new ServiceContext());
        }
        if (PropsValues.DL_FILE_ENTRY_READ_COUNT_ENABLED) {
            fileEntry.setReadCount(fileEntry.getReadCount() + 1);
            this.dlFileEntryPersistence.update((BaseModel)fileEntry, false);
            this.assetEntryLocalService.incrementViewCounter(userId, DLFileEntry.class.getName(), fileEntry.getFileEntryId());
            List fileShortcuts = this.dlFileShortcutPersistence.findByG_TF_TN(groupId, folderId, name);
            for (DLFileShortcut fileShortcut : fileShortcuts) {
                this.assetEntryLocalService.incrementViewCounter(userId, DLFileShortcut.class.getName(), fileShortcut.getFileShortcutId());
            }
        }
        if (Validator.isNotNull((String)version)) {
            return this.dlLocalService.getFileAsStream(companyId, fileEntry.getRepositoryId(), name, version);
        }
        return this.dlLocalService.getFileAsStream(companyId, fileEntry.getRepositoryId(), name, fileEntry.getVersion());
    }

    public List<DLFileEntry> getFileEntries(long groupId, long folderId) throws SystemException {
        return this.dlFileEntryPersistence.findByG_F(groupId, folderId);
    }

    public List<DLFileEntry> getFileEntries(long groupId, long folderId, int start, int end) throws SystemException {
        return this.dlFileEntryPersistence.findByG_F(groupId, folderId, start, end);
    }

    public List<DLFileEntry> getFileEntries(long groupId, long folderId, int start, int end, OrderByComparator obc) throws SystemException {
        return this.dlFileEntryPersistence.findByG_F(groupId, folderId, start, end, obc);
    }

    public int getFileEntriesCount(long groupId, long folderId) throws SystemException {
        return this.dlFileEntryPersistence.countByG_F(groupId, folderId);
    }

    public DLFileEntry getFileEntry(long fileEntryId) throws PortalException, SystemException {
        return this.dlFileEntryPersistence.findByPrimaryKey(fileEntryId);
    }

    public DLFileEntry getFileEntry(long groupId, long folderId, String name) throws PortalException, SystemException {
        return this.dlFileEntryPersistence.findByG_F_N(groupId, folderId, name);
    }

    public DLFileEntry getFileEntryByTitle(long groupId, long folderId, String title) throws PortalException, SystemException {
        return this.dlFileEntryPersistence.findByG_F_T(groupId, folderId, title);
    }

    public DLFileEntry getFileEntryByUuidAndGroupId(String uuid, long groupId) throws PortalException, SystemException {
        return this.dlFileEntryPersistence.findByUUID_G(uuid, groupId);
    }

    public int getFoldersFileEntriesCount(long groupId, List<Long> folderIds, int status) throws SystemException {
        if (folderIds.size() <= PropsValues.SQL_DATA_MAX_PARAMETERS) {
            return this.dlFileEntryFinder.countByG_F_S(groupId, folderIds, status);
        }
        int start = 0;
        int end = PropsValues.SQL_DATA_MAX_PARAMETERS;
        int filesCount = this.dlFileEntryFinder.countByG_F_S(groupId, folderIds.subList(start, end), status);
        folderIds.subList(start, end).clear();
        return filesCount += this.getFoldersFileEntriesCount(groupId, folderIds, status);
    }

    public List<DLFileEntry> getGroupFileEntries(long groupId, int start, int end) throws SystemException {
        return this.getGroupFileEntries(groupId, start, end, (OrderByComparator)new FileEntryModifiedDateComparator());
    }

    public List<DLFileEntry> getGroupFileEntries(long groupId, int start, int end, OrderByComparator obc) throws SystemException {
        return this.dlFileEntryPersistence.findByGroupId(groupId, start, end, obc);
    }

    public List<DLFileEntry> getGroupFileEntries(long groupId, long userId, int start, int end) throws SystemException {
        return this.getGroupFileEntries(groupId, userId, start, end, (OrderByComparator)new FileEntryModifiedDateComparator());
    }

    public List<DLFileEntry> getGroupFileEntries(long groupId, long userId, int start, int end, OrderByComparator obc) throws SystemException {
        if (userId <= 0L) {
            return this.dlFileEntryPersistence.findByGroupId(groupId, start, end, obc);
        }
        return this.dlFileEntryPersistence.findByG_U(groupId, userId, start, end, obc);
    }

    public int getGroupFileEntriesCount(long groupId) throws SystemException {
        return this.dlFileEntryPersistence.countByGroupId(groupId);
    }

    public int getGroupFileEntriesCount(long groupId, long userId) throws SystemException {
        if (userId <= 0L) {
            return this.dlFileEntryPersistence.countByGroupId(groupId);
        }
        return this.dlFileEntryPersistence.countByG_U(groupId, userId);
    }

    public List<DLFileEntry> getNoAssetFileEntries() throws SystemException {
        return this.dlFileEntryFinder.findByNoAssets();
    }

    public DLFileEntry moveFileEntry(long userId, long groupId, long folderId, long newFolderId, String name, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        DLFileEntry fileEntry = this.dlFileEntryPersistence.findByG_F_N(groupId, folderId, name);
        long oldFileEntryId = fileEntry.getFileEntryId();
        if (this.dlLocalService.hasFile(user.getCompanyId(), DLFileEntryImpl.getRepositoryId(groupId, newFolderId), name, "")) {
            throw new DuplicateFileException(name);
        }
        long newFileEntryId = this.counterLocalService.increment();
        DLFileEntry newFileEntry = this.dlFileEntryPersistence.create(newFileEntryId);
        newFileEntry.setGroupId(fileEntry.getGroupId());
        newFileEntry.setCompanyId(fileEntry.getCompanyId());
        newFileEntry.setUserId(fileEntry.getUserId());
        newFileEntry.setUserName(fileEntry.getUserName());
        newFileEntry.setVersionUserId(fileEntry.getVersionUserId());
        newFileEntry.setVersionUserName(fileEntry.getVersionUserName());
        newFileEntry.setCreateDate(fileEntry.getCreateDate());
        newFileEntry.setModifiedDate(fileEntry.getModifiedDate());
        newFileEntry.setFolderId(newFolderId);
        newFileEntry.setName(name);
        newFileEntry.setExtension(fileEntry.getExtension());
        newFileEntry.setTitle(fileEntry.getTitle());
        newFileEntry.setDescription(fileEntry.getDescription());
        newFileEntry.setExtraSettings(fileEntry.getExtraSettings());
        newFileEntry.setVersion(fileEntry.getVersion());
        newFileEntry.setSize(fileEntry.getSize());
        newFileEntry.setReadCount(fileEntry.getReadCount());
        this.dlFileEntryPersistence.update((BaseModel)newFileEntry, false);
        this.dlFileEntryPersistence.remove((BaseModel)fileEntry);
        this.workflowInstanceLinkLocalService.updateClassPK(fileEntry.getCompanyId(), fileEntry.getGroupId(), DLFileEntry.class.getName(), oldFileEntryId, newFileEntryId);
        List fileVersions = this.dlFileVersionPersistence.findByG_F_N(groupId, folderId, name);
        for (DLFileVersion fileVersion : fileVersions) {
            long newFileVersionId = this.counterLocalService.increment();
            DLFileVersion newFileVersion = this.dlFileVersionPersistence.create(newFileVersionId);
            newFileVersion.setGroupId(fileVersion.getGroupId());
            newFileVersion.setCompanyId(fileVersion.getCompanyId());
            newFileVersion.setUserId(fileVersion.getUserId());
            newFileVersion.setUserName(fileVersion.getUserName());
            newFileVersion.setCreateDate(fileVersion.getCreateDate());
            newFileVersion.setFolderId(newFolderId);
            newFileVersion.setName(name);
            newFileVersion.setExtension(fileVersion.getExtension());
            newFileVersion.setTitle(fileVersion.getTitle());
            newFileVersion.setDescription(fileVersion.getDescription());
            newFileVersion.setChangeLog(fileVersion.getChangeLog());
            newFileVersion.setExtraSettings(fileVersion.getExtraSettings());
            newFileVersion.setVersion(fileVersion.getVersion());
            newFileVersion.setSize(fileVersion.getSize());
            newFileVersion.setStatus(fileVersion.getStatus());
            newFileVersion.setStatusByUserId(userId);
            newFileVersion.setStatusByUserName(user.getFullName());
            newFileVersion.setStatusDate(serviceContext.getModifiedDate(now));
            this.dlFileVersionPersistence.update((BaseModel)newFileVersion, false);
            this.dlFileVersionPersistence.remove((BaseModel)fileVersion);
        }
        this.dlFileShortcutLocalService.updateFileShortcuts(groupId, folderId, name, newFolderId, name);
        this.resourceLocalService.updateResources(fileEntry.getCompanyId(), DLFileEntry.class.getName(), 4, String.valueOf(fileEntry.getFileEntryId()), String.valueOf(newFileEntryId));
        this.assetEntryLocalService.deleteEntry(DLFileEntry.class.getName(), fileEntry.getFileEntryId());
        List fileShortcuts = this.dlFileShortcutPersistence.findByG_TF_TN(groupId, folderId, name);
        for (DLFileShortcut fileShortcut : fileShortcuts) {
            this.assetEntryLocalService.deleteEntry(DLFileShortcut.class.getName(), fileShortcut.getFileShortcutId());
        }
        this.expandoValueLocalService.deleteValues(DLFileEntry.class.getName(), fileEntry.getFileEntryId());
        RatingsStats stats = this.ratingsStatsLocalService.getStats(DLFileEntry.class.getName(), oldFileEntryId);
        stats.setClassPK(newFileEntryId);
        this.ratingsStatsPersistence.update((BaseModel)stats, false);
        long classNameId = PortalUtil.getClassNameId((String)DLFileEntry.class.getName());
        List entries = this.ratingsEntryPersistence.findByC_C(classNameId, oldFileEntryId);
        for (RatingsEntry entry : entries) {
            entry.setClassPK(newFileEntryId);
            this.ratingsEntryPersistence.update((BaseModel)entry, false);
        }
        MBDiscussion discussion = this.mbDiscussionPersistence.fetchByC_C(classNameId, oldFileEntryId);
        if (discussion != null) {
            discussion.setClassPK(newFileEntryId);
            this.mbDiscussionPersistence.update((BaseModel)discussion, false);
        }
        this.socialActivityLocalService.deleteActivities(DLFileEntry.class.getName(), fileEntry.getFileEntryId());
        this.dlService.updateFile(user.getCompanyId(), "20", newFileEntry.getGroupId(), fileEntry.getRepositoryId(), newFileEntry.getRepositoryId(), name, newFileEntryId);
        return newFileEntry;
    }

    public void updateAsset(long userId, DLFileEntry fileEntry, DLFileVersion fileVersion, long[] assetCategoryIds, String[] assetTagNames) throws PortalException, SystemException {
        int approvedArticlesCount;
        String mimeType = MimeTypesUtil.getContentType((String)fileEntry.getTitle());
        boolean addDraftAssetEntry = false;
        if (fileVersion != null && !fileVersion.isApproved() && fileVersion.getVersion() != "1.0" && (approvedArticlesCount = this.dlFileVersionPersistence.countByG_F_N_S(fileEntry.getGroupId(), fileEntry.getFolderId(), fileEntry.getName(), 0)) > 0) {
            addDraftAssetEntry = true;
        }
        if (addDraftAssetEntry) {
            this.assetEntryLocalService.updateEntry(userId, fileEntry.getGroupId(), DLFileEntry.class.getName(), fileVersion.getFileVersionId(), fileEntry.getUuid(), assetCategoryIds, assetTagNames, false, null, null, null, null, mimeType, fileEntry.getTitle(), fileEntry.getDescription(), null, null, 0, 0, null, false);
        } else {
            boolean visible = true;
            if (fileVersion != null && !fileVersion.isApproved()) {
                visible = false;
            }
            this.assetEntryLocalService.updateEntry(userId, fileEntry.getGroupId(), DLFileEntry.class.getName(), fileEntry.getFileEntryId(), fileEntry.getUuid(), assetCategoryIds, assetTagNames, visible, null, null, null, null, mimeType, fileEntry.getTitle(), fileEntry.getDescription(), null, null, 0, 0, null, false);
            List fileShortcuts = this.dlFileShortcutPersistence.findByG_TF_TN(fileEntry.getGroupId(), fileEntry.getFolderId(), fileEntry.getName());
            for (DLFileShortcut fileShortcut : fileShortcuts) {
                this.assetEntryLocalService.updateEntry(userId, fileShortcut.getGroupId(), DLFileShortcut.class.getName(), fileShortcut.getFileShortcutId(), fileShortcut.getUuid(), assetCategoryIds, assetTagNames, true, null, null, null, null, mimeType, fileEntry.getTitle(), fileEntry.getDescription(), null, null, 0, 0, null, false);
            }
        }
    }

    public DLFileEntry updateFileEntry(long userId, long groupId, long folderId, String name, String sourceFileName, String title, String description, String changeLog, boolean majorVersion, String extraSettings, byte[] bytes, ServiceContext serviceContext) throws PortalException, SystemException {
        UnsyncByteArrayInputStream is = null;
        long size = 0L;
        if (bytes != null) {
            is = new UnsyncByteArrayInputStream(bytes);
            size = bytes.length;
        }
        return this.updateFileEntry(userId, groupId, folderId, name, sourceFileName, title, description, changeLog, majorVersion, extraSettings, (InputStream)is, size, serviceContext);
    }

    public DLFileEntry updateFileEntry(long userId, long groupId, long folderId, String name, String sourceFileName, String title, String description, String changeLog, boolean majorVersion, String extraSettings, File file, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            UnsyncBufferedInputStream is = null;
            long size = 0L;
            if (file != null && file.exists()) {
                is = new UnsyncBufferedInputStream((InputStream)new FileInputStream(file));
                size = file.length();
            }
            return this.updateFileEntry(userId, groupId, folderId, name, sourceFileName, title, description, changeLog, majorVersion, extraSettings, (InputStream)is, size, serviceContext);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new NoSuchFileException();
        }
    }

    public DLFileEntry updateFileEntry(long userId, long groupId, long folderId, String name, String sourceFileName, String title, String description, String changeLog, boolean majorVersion, String extraSettings, InputStream is, long size, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        if (Validator.isNull((String)title) && Validator.isNull((String)(title = sourceFileName))) {
            title = name;
        }
        Date now = new Date();
        DLFileEntry fileEntry = this.dlFileEntryPersistence.findByG_F_N(groupId, folderId, name);
        this.validate(groupId, folderId, name, fileEntry.getExtension(), title, sourceFileName, is);
        String version = this.getNextVersion(fileEntry, majorVersion, serviceContext.getWorkflowAction());
        DLFileVersion fileVersion = null;
        String extension = null;
        extension = Validator.isNotNull((String)sourceFileName) ? FileUtil.getExtension((String)sourceFileName) : fileEntry.getExtension();
        boolean updatedFileVersion = false;
        try {
            DLFileVersion latestFileVersion = this.dlFileVersionLocalService.getLatestFileVersion(groupId, folderId, name);
            if (size == 0L) {
                size = latestFileVersion.getSize();
            }
            if (latestFileVersion.getStatus() != 0) {
                serviceContext.setWorkflowAction(2);
                version = latestFileVersion.getVersion();
                updatedFileVersion = true;
                this.updateFileVersion(user, latestFileVersion, sourceFileName, extension, title, description, changeLog, extraSettings, version, size, latestFileVersion.getStatus(), serviceContext.getModifiedDate(now), serviceContext);
            } else {
                fileVersion = this.addFileVersion(user, fileEntry, serviceContext.getModifiedDate(now), extension, title, description, changeLog, extraSettings, version, size, 2, serviceContext);
            }
            if (fileVersion == null) {
                fileVersion = latestFileVersion;
            }
        }
        catch (NoSuchFileVersionException noSuchFileVersionException) {
            fileVersion = this.addFileVersion(user, fileEntry, serviceContext.getModifiedDate(now), extension, title, description, changeLog, extraSettings, version, size, 2, serviceContext);
        }
        if (is == null && !updatedFileVersion) {
            int fetchFailures = 0;
            while (is == null) {
                try {
                    is = this.dlLocalService.getFileAsStream(user.getCompanyId(), fileEntry.getRepositoryId(), name);
                }
                catch (NoSuchFileException nsfe) {
                    if (PropsValues.DL_HOOK_IMPL.equals(JCRHook.class.getName()) && ++fetchFailures < PropsValues.DL_HOOK_JCR_FETCH_MAX_FAILURES) {
                        try {
                            Thread.sleep(PropsValues.DL_HOOK_JCR_FETCH_DELAY);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    throw nsfe;
                }
            }
        }
        this.updateAsset(userId, fileEntry, fileVersion, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        if (fileEntry.getFolderId() != 0L) {
            DLFolder folder = this.dlFolderPersistence.findByPrimaryKey(fileEntry.getFolderId());
            folder.setLastPostDate(fileEntry.getModifiedDate());
            this.dlFolderPersistence.update((BaseModel)folder, false);
        }
        if (is != null) {
            try {
                this.dlService.deleteFile(user.getCompanyId(), "20", fileEntry.getRepositoryId(), fileEntry.getName(), version);
            }
            catch (NoSuchFileException noSuchFileException) {}
            this.dlLocalService.updateFile(user.getCompanyId(), "20", fileEntry.getGroupId(), fileEntry.getRepositoryId(), name, fileEntry.getExtension(), false, version, sourceFileName, fileEntry.getFileEntryId(), fileEntry.getLuceneProperties(), fileEntry.getModifiedDate(), serviceContext, is);
        }
        WorkflowHandlerRegistryUtil.startWorkflowInstance((long)user.getCompanyId(), (long)groupId, (long)userId, (String)DLFileEntry.class.getName(), (long)fileEntry.getFileEntryId(), (Object)fileEntry, (ServiceContext)serviceContext);
        return fileEntry;
    }

    public DLFileEntry updateStatus(long userId, long fileEntryId, int status, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        DLFileEntry fileEntry = this.dlFileEntryPersistence.findByPrimaryKey(fileEntryId);
        DLFileVersion latestFileVersion = this.dlFileVersionLocalService.getLatestFileVersion(fileEntry.getGroupId(), fileEntry.getFolderId(), fileEntry.getName());
        latestFileVersion.setStatus(status);
        latestFileVersion.setStatusByUserId(user.getUserId());
        latestFileVersion.setStatusByUserName(user.getFullName());
        latestFileVersion.setStatusDate(new Date());
        this.dlFileVersionPersistence.update((BaseModel)latestFileVersion, false);
        if (status == 0) {
            if (DLUtil.compareVersions((String)fileEntry.getVersion(), (String)latestFileVersion.getVersion()) < 0) {
                fileEntry.setTitle(latestFileVersion.getTitle());
                fileEntry.setDescription(latestFileVersion.getDescription());
                fileEntry.setExtraSettings(latestFileVersion.getExtraSettings());
                fileEntry.setVersion(latestFileVersion.getVersion());
                fileEntry.setVersionUserId(latestFileVersion.getUserId());
                fileEntry.setVersionUserName(latestFileVersion.getUserName());
                fileEntry.setModifiedDate(latestFileVersion.getCreateDate());
                fileEntry.setSize(latestFileVersion.getSize());
                this.dlFileEntryPersistence.update((BaseModel)fileEntry, false);
            }
            if (fileEntry.getVersion().equals(latestFileVersion.getVersion())) {
                if (latestFileVersion.getVersion() != "1.0") {
                    AssetEntry draftAssetEntry = null;
                    try {
                        draftAssetEntry = this.assetEntryLocalService.getEntry(DLFileEntry.class.getName(), latestFileVersion.getPrimaryKey());
                        long[] assetCategoryIds = draftAssetEntry.getCategoryIds();
                        String[] assetTagNames = draftAssetEntry.getTagNames();
                        this.assetEntryLocalService.updateEntry(userId, fileEntry.getGroupId(), DLFileEntry.class.getName(), fileEntry.getFileEntryId(), fileEntry.getUuid(), assetCategoryIds, assetTagNames, true, null, null, null, null, draftAssetEntry.getMimeType(), fileEntry.getTitle(), fileEntry.getDescription(), null, null, 0, 0, null, false);
                        this.assetEntryLocalService.deleteEntry(draftAssetEntry.getEntryId());
                    }
                    catch (NoSuchEntryException noSuchEntryException) {}
                }
                this.assetEntryLocalService.updateVisible(DLFileEntry.class.getName(), fileEntry.getFileEntryId(), true);
            }
            this.socialActivityLocalService.addUniqueActivity(latestFileVersion.getUserId(), latestFileVersion.getGroupId(), latestFileVersion.getCreateDate(), DLFileEntry.class.getName(), fileEntryId, 1, "", 0L);
            Indexer indexer = IndexerRegistryUtil.getIndexer(DLFileEntry.class);
            indexer.reindex((Object)fileEntry);
        } else {
            if (fileEntry.getVersion().equals(latestFileVersion.getVersion())) {
                String newVersion = "1.0";
                List approvedFileVersions = this.dlFileVersionPersistence.findByG_F_N_S(fileEntry.getGroupId(), fileEntry.getFolderId(), fileEntry.getName(), 0);
                if (!approvedFileVersions.isEmpty()) {
                    newVersion = ((DLFileVersion)approvedFileVersions.get(0)).getVersion();
                }
                fileEntry.setVersion(newVersion);
                this.dlFileEntryPersistence.update((BaseModel)fileEntry, false);
            }
            if (Validator.isNull((String)fileEntry.getVersion())) {
                this.assetEntryLocalService.updateVisible(DLFileEntry.class.getName(), fileEntry.getFileEntryId(), false);
            }
            if (latestFileVersion.getVersion().equals("1.0")) {
                Indexer indexer = IndexerRegistryUtil.getIndexer(DLFileEntry.class);
                indexer.delete((Object)fileEntry);
            }
        }
        return fileEntry;
    }

    protected DLFileVersion addFileVersion(User user, DLFileEntry fileEntry, Date modifiedDate, String extension, String title, String description, String changeLog, String extraSettings, String version, long size, int status, ServiceContext serviceContext) throws SystemException {
        long fileVersionId = this.counterLocalService.increment();
        DLFileVersion fileVersion = this.dlFileVersionPersistence.create(fileVersionId);
        long versionUserId = fileEntry.getVersionUserId();
        if (versionUserId <= 0L) {
            versionUserId = fileEntry.getUserId();
        }
        String versionUserName = GetterUtil.getString((String)fileEntry.getVersionUserName(), (String)fileEntry.getUserName());
        fileVersion.setGroupId(fileEntry.getGroupId());
        fileVersion.setCompanyId(fileEntry.getCompanyId());
        fileVersion.setUserId(versionUserId);
        fileVersion.setUserName(versionUserName);
        fileVersion.setCreateDate(modifiedDate);
        fileVersion.setFolderId(fileEntry.getFolderId());
        fileVersion.setName(fileEntry.getName());
        fileVersion.setExtension(extension);
        fileVersion.setTitle(title);
        fileVersion.setDescription(description);
        fileVersion.setChangeLog(changeLog);
        fileVersion.setExtraSettings(extraSettings);
        fileVersion.setVersion(version);
        fileVersion.setSize(size);
        fileVersion.setStatus(status);
        fileVersion.setStatusByUserId(user.getUserId());
        fileVersion.setStatusByUserName(user.getFullName());
        fileVersion.setStatusDate(fileEntry.getModifiedDate());
        fileVersion.setExpandoBridgeAttributes(serviceContext);
        this.dlFileVersionPersistence.update((BaseModel)fileVersion, false);
        return fileVersion;
    }

    protected long getFolderId(long companyId, long folderId) throws SystemException {
        DLFolder folder;
        if (folderId != 0L && ((folder = this.dlFolderPersistence.fetchByPrimaryKey(folderId)) == null || companyId != folder.getCompanyId())) {
            folderId = 0L;
        }
        return folderId;
    }

    protected String getNextVersion(DLFileEntry fileEntry, boolean majorVersion, int workflowAction) {
        if (Validator.isNull((String)fileEntry.getVersion())) {
            return "1.0";
        }
        if (workflowAction == 2) {
            majorVersion = false;
        }
        int[] versionParts = StringUtil.split((String)fileEntry.getVersion(), (String)".", (int)0);
        if (majorVersion) {
            versionParts[0] = versionParts[0] + 1;
            versionParts[1] = 0;
        } else {
            versionParts[1] = versionParts[1] + 1;
        }
        return String.valueOf(versionParts[0]) + "." + versionParts[1];
    }

    protected void updateFileVersion(User user, DLFileVersion fileVersion, String sourceFileName, String extension, String title, String description, String changeLog, String extraSettings, String version, long size, int status, Date statusDate, ServiceContext serviceContext) throws SystemException {
        if (Validator.isNotNull((String)sourceFileName)) {
            fileVersion.setExtension(extension);
        }
        fileVersion.setTitle(title);
        fileVersion.setDescription(description);
        fileVersion.setChangeLog(changeLog);
        fileVersion.setExtraSettings(extraSettings);
        fileVersion.setVersion(version);
        fileVersion.setSize(size);
        fileVersion.setStatus(status);
        fileVersion.setStatusByUserId(user.getUserId());
        fileVersion.setStatusByUserName(user.getFullName());
        fileVersion.setStatusDate(statusDate);
        fileVersion.setExpandoBridgeAttributes(serviceContext);
        this.dlFileVersionPersistence.update((BaseModel)fileVersion, false);
    }

    protected void validate(long groupId, long folderId, String title, InputStream is) throws PortalException, SystemException {
        this.dlLocalService.validate(title, true, is);
        this.validate(groupId, folderId, null, title);
    }

    protected void validate(long groupId, long folderId, String name, String title) throws PortalException, SystemException {
        try {
            this.dlFolderLocalService.getFolder(groupId, folderId, title);
            throw new DuplicateFolderNameException();
        }
        catch (NoSuchFolderException noSuchFolderException) {
            try {
                DLFileEntry fileEntry = this.dlFileEntryPersistence.findByG_F_T(groupId, folderId, title);
                if (!fileEntry.getName().equals(name)) {
                    throw new DuplicateFileException(title);
                }
            }
            catch (NoSuchFileEntryException noSuchFileEntryException) {}
            return;
        }
    }

    protected void validate(long groupId, long folderId, String name, String extension, String title, String sourceFileName, InputStream is) throws PortalException, SystemException {
        if (Validator.isNotNull((String)sourceFileName)) {
            this.dlLocalService.validate(sourceFileName, extension, sourceFileName, true, is);
        }
        this.validate(groupId, folderId, name, title);
    }
}

