/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.asset;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.model.BaseAssetRenderer;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.service.permission.DLFileEntryPermission;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public class DLFileEntryAssetRenderer
extends BaseAssetRenderer {
    private DLFileEntry _fileEntry;
    private DLFileVersion _fileVersion;

    public DLFileEntryAssetRenderer(DLFileEntry fileEntry, DLFileVersion fileVersion) {
        this._fileEntry = fileEntry;
        this._fileVersion = fileVersion;
    }

    public long getClassPK() {
        if (!this._fileVersion.isApproved() && this._fileVersion.getVersion() != "1.0") {
            return this._fileVersion.getFileVersionId();
        }
        return this._fileEntry.getFileEntryId();
    }

    public String getDiscussionPath() {
        if (PropsValues.DL_FILE_ENTRY_COMMENTS_ENABLED) {
            return "edit_file_entry_discussion";
        }
        return null;
    }

    public long getGroupId() {
        return this._fileEntry.getGroupId();
    }

    public String getSummary() {
        return HtmlUtil.stripHtml((String)this._fileEntry.getDescription());
    }

    public String getTitle() {
        return this._fileEntry.getTitle();
    }

    public PortletURL getURLEdit(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        LiferayPortletURL editPortletURL = liferayPortletResponse.createRenderURL("20");
        editPortletURL.setParameter("struts_action", "/document_library/edit_file_entry");
        editPortletURL.setParameter("groupId", String.valueOf(this._fileEntry.getGroupId()));
        editPortletURL.setParameter("folderId", String.valueOf(this._fileEntry.getFolderId()));
        editPortletURL.setParameter("name", String.valueOf(this._fileEntry.getName()));
        return editPortletURL;
    }

    public PortletURL getURLExport(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        PortletURL exportPortletURL = liferayPortletResponse.createActionURL();
        exportPortletURL.setParameter("struts_action", "/asset_publisher/get_file");
        exportPortletURL.setParameter("groupId", String.valueOf(this._fileEntry.getGroupId()));
        exportPortletURL.setParameter("folderId", String.valueOf(this._fileEntry.getFolderId()));
        exportPortletURL.setParameter("title", String.valueOf(this._fileEntry.getTitle()));
        return exportPortletURL;
    }

    public String getURLViewInContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String noSuchEntryRedirect) {
        ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("THEME_DISPLAY");
        return String.valueOf(themeDisplay.getPathMain()) + "/document_library/find_file_entry?p_l_id=" + themeDisplay.getPlid() + "&fileEntryId=" + this._fileEntry.getFileEntryId();
    }

    public long getUserId() {
        return this._fileEntry.getUserId();
    }

    public String getUuid() {
        return this._fileEntry.getUuid();
    }

    public boolean hasEditPermission(PermissionChecker permissionChecker) throws PortalException, SystemException {
        return DLFileEntryPermission.contains(permissionChecker, this._fileEntry, "UPDATE");
    }

    public boolean hasViewPermission(PermissionChecker permissionChecker) throws PortalException, SystemException {
        return DLFileEntryPermission.contains(permissionChecker, this._fileEntry, "VIEW");
    }

    public boolean isConvertible() {
        return true;
    }

    public boolean isPrintable() {
        return false;
    }

    public String render(RenderRequest renderRequest, RenderResponse renderResponse, String template) throws Exception {
        if (template.equals("abstract") || template.equals("full_content")) {
            renderRequest.setAttribute("DOCUMENT_LIBRARY_FILE_ENTRY", (Object)this._fileEntry);
            renderRequest.setAttribute("DOCUMENT_LIBRARY_FILE_VERSION", (Object)this._fileVersion);
            return "/html/portlet/document_library/asset/" + template + ".jsp";
        }
        return null;
    }

    protected String getIconPath(ThemeDisplay themeDisplay) {
        return String.valueOf(themeDisplay.getPathThemeImages()) + "/common/clip.png";
    }
}

