/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletBag;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletApp;
import com.liferay.portlet.PortletContextImpl;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletContext;
import javax.servlet.ServletContext;

public class PortletContextFactory {
    private static Log _log = LogFactoryUtil.getLog(PortletContextFactory.class);
    private static PortletContextFactory _instance = new PortletContextFactory();
    private Map<String, Map<String, PortletContext>> _pool = new ConcurrentHashMap<String, Map<String, PortletContext>>();

    public static PortletContext create(Portlet portlet, ServletContext servletContext) {
        return _instance._create(portlet, servletContext);
    }

    public static void destroy(Portlet portlet) {
        _instance._destroy(portlet);
    }

    private PortletContextFactory() {
    }

    private PortletContext _create(Portlet portlet, ServletContext servletContext) {
        PortletContext portletContext;
        Map<String, PortletContext> portletContexts = this._pool.get(portlet.getRootPortletId());
        if (portletContexts == null) {
            portletContexts = new ConcurrentHashMap<String, PortletContext>();
            this._pool.put(portlet.getRootPortletId(), portletContexts);
        }
        if ((portletContext = portletContexts.get(portlet.getPortletId())) == null) {
            PortletApp portletApp = portlet.getPortletApp();
            if (portletApp.isWARFile()) {
                PortletBag portletBag = PortletBagPool.get((String)portlet.getRootPortletId());
                if (portletBag == null) {
                    _log.error((Object)("Portlet " + portlet.getRootPortletId() + " has a null portlet bag"));
                }
                servletContext = portletBag.getServletContext();
            }
            portletContext = new PortletContextImpl(portlet, servletContext);
            portletContexts.put(portlet.getPortletId(), portletContext);
        }
        return portletContext;
    }

    private void _destroy(Portlet portlet) {
        Map<String, PortletContext> portletContexts = this._pool.remove(portlet.getRootPortletId());
        if (portletContexts == null) {
            return;
        }
        Iterator<Map.Entry<String, PortletContext>> itr = portletContexts.entrySet().iterator();
        if (itr.hasNext()) {
            Map.Entry<String, PortletContext> entry = itr.next();
            PortletContext portletContext = entry.getValue();
            ServletContextPool.remove((String)portletContext.getPortletContextName());
        }
    }
}

