/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.Layout;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SitemapUtil {
    public static String getSitemap(long groupId, boolean privateLayout, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        Document doc = SAXReaderUtil.createDocument();
        doc.setXMLEncoding("UTF-8");
        Element root = doc.addElement("urlset", "http://www.google.com/schemas/sitemap/0.84");
        List layouts = LayoutLocalServiceUtil.getLayouts((long)groupId, (boolean)privateLayout, (long)0L);
        SitemapUtil._visitLayouts(root, layouts, themeDisplay);
        return doc.asXML();
    }

    public static String encodeXML(String input) {
        return StringUtil.replace((String)input, (String[])new String[]{"&", "<", ">", "'", "\""}, (String[])new String[]{"&amp;", "&lt;", "&gt;", "&apos;", "&quot;"});
    }

    private static void _visitLayouts(Element element, List<Layout> layouts, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        for (Layout layout : layouts) {
            String priority;
            UnicodeProperties props = layout.getTypeSettingsProperties();
            if (!PortalUtil.isLayoutSitemapable((Layout)layout) || layout.isHidden() || !GetterUtil.getBoolean((String)props.getProperty("sitemap-include"), (boolean)true)) continue;
            Element url = element.addElement("url");
            String layoutFullURL = PortalUtil.getLayoutFullURL((Layout)layout, (ThemeDisplay)themeDisplay);
            url.addElement("loc").addText(SitemapUtil.encodeXML(layoutFullURL));
            String changefreq = props.getProperty("sitemap-changefreq");
            if (Validator.isNotNull((String)changefreq)) {
                url.addElement("changefreq").addText(changefreq);
            }
            if (Validator.isNotNull((String)(priority = props.getProperty("sitemap-priority")))) {
                url.addElement("priority").addText(priority);
            }
            List children = layout.getChildren();
            SitemapUtil._visitLayouts(element, children, themeDisplay);
        }
    }
}

