/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.image.ImageProcessorImpl;
import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.util.GetterUtil;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;

public class ThumbnailBuilder {
    private static ImageProcessorImpl _imageProcessorUtil = ImageProcessorImpl.getInstance();

    public static void main(String[] args) {
        File originalFile = new File(System.getProperty("thumbnail.original.file"));
        File thumbnailFile = new File(System.getProperty("thumbnail.thumbnail.file"));
        int height = GetterUtil.getInteger((String)System.getProperty("thumbnail.height"));
        int width = GetterUtil.getInteger((String)System.getProperty("thumbnail.width"));
        boolean overwrite = GetterUtil.getBoolean((String)System.getProperty("thumbnail.overwrite"));
        new ThumbnailBuilder(originalFile, thumbnailFile, height, width, overwrite);
    }

    public ThumbnailBuilder(File originalFile, File thumbnailFile, int height, int width, boolean overwrite) {
        try {
            if (!originalFile.exists()) {
                return;
            }
            if (!overwrite && thumbnailFile.lastModified() > originalFile.lastModified()) {
                return;
            }
            ImageBag imageBag = _imageProcessorUtil.read(originalFile);
            RenderedImage thumbnail = _imageProcessorUtil.scale(imageBag.getRenderedImage(), height, width);
            ImageIO.write(thumbnail, imageBag.getType(), thumbnailFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

