/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.sharepoint;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.sharepoint.SharepointStorage;
import com.liferay.portal.sharepoint.SharepointUtil;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SharepointRequest {
    private SharepointStorage _storage;
    private HttpServletRequest _request;
    private HttpServletResponse _response;
    private String _rootPath = "";
    private User _user;
    private byte[] _bytes;
    private Map<String, String[]> _params = new HashMap<String, String[]>();

    public SharepointRequest(String rootPath) {
        this._rootPath = rootPath;
    }

    public SharepointRequest(HttpServletRequest request, HttpServletResponse response, User user) {
        this._request = request;
        this._response = response;
        this._user = user;
        this._params.putAll(request.getParameterMap());
    }

    public void addParam(String key, String value) {
        this._params.put(key, new String[]{value});
    }

    public byte[] getBytes() {
        return this._bytes;
    }

    public long getCompanyId() {
        return this._user.getCompanyId();
    }

    public HttpServletRequest getHttpServletRequest() {
        return this._request;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this._response;
    }

    public String getParameterValue(String name) {
        String[] values = this._params.get(name);
        if (values != null && values.length > 0) {
            return GetterUtil.getString((String)this._params.get(name)[0]);
        }
        return "";
    }

    public String getRootPath() {
        return this._rootPath;
    }

    public SharepointStorage getSharepointStorage() {
        return this._storage;
    }

    public User getUser() {
        return this._user;
    }

    public long getUserId() {
        return this._user.getUserId();
    }

    public void setBytes(byte[] bytes) {
        this._bytes = bytes;
    }

    public void setRootPath(String rootPath) {
        this._rootPath = SharepointUtil.replaceBackSlashes(rootPath);
    }

    public void setSharepointStorage(SharepointStorage storage) {
        this._storage = storage;
    }
}

